/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.world.level.block.entity;

import fuzs.plentyplates.init.ModRegistry;
import fuzs.plentyplates.world.inventory.PressurePlateMenu;
import fuzs.plentyplates.world.level.block.DirectionalPressurePlateBlock;
import fuzs.plentyplates.world.level.block.PressurePlateSetting;
import fuzs.plentyplates.world.level.block.SensitivityMaterial;
import fuzs.plentyplates.world.level.block.entity.data.DataStorage;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PressurePlateBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String TAG_SETTINGS = "Settings";
    public static final String TAG_MATERIAL = "Material";
    public static final String TAG_OWNER = "Owner";
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return PressurePlateBlockEntity.this.getSettingsValue(index);
        }

        public void m_8050_(int index, int value) {
            PressurePlateBlockEntity.this.setSettingsValue(index, value);
        }

        public int m_6499_() {
            return PressurePlateSetting.values().length;
        }
    };
    @Nullable
    private UUID owner;
    private SensitivityMaterial sensitivityMaterial;
    private DataStorage<?> dataStorage;
    private int settings = PressurePlateSetting.DEFAULT_SETTINGS;

    public PressurePlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.PRESSURE_PLATE_BLOCK_ENTITY_TYPE.get(), blockPos, blockState);
    }

    public PressurePlateBlockEntity(SensitivityMaterial sensitivityMaterial, BlockPos blockPos, BlockState blockState) {
        this(blockPos, blockState);
        this.setSensitivityMaterial(sensitivityMaterial);
    }

    public void setSensitivityMaterial(SensitivityMaterial sensitivityMaterial) {
        this.sensitivityMaterial = sensitivityMaterial;
        this.dataStorage = new DataStorage(sensitivityMaterial.dataProvider.get());
    }

    public void setSettingsValue(int id, int value) {
        this.settings = this.settings & ~(1 << id) | (value & 1) << id;
        this.update(PressurePlateSetting.values()[id], value == 1);
        this.m_6596_();
    }

    public int getSettingsValue(int id) {
        return this.settings >> id & 1;
    }

    public boolean getSettingsValue(PressurePlateSetting setting) {
        return this.getSettingsValue(setting.ordinal()) == 1;
    }

    public boolean allowedToAccess(Player player) {
        if (!player.m_150110_().f_35938_) {
            return false;
        }
        if (!this.getSettingsValue(PressurePlateSetting.LOCKED) && this.owner != null) {
            return this.owner.equals(player.m_20148_());
        }
        return true;
    }

    private void update(PressurePlateSetting setting, boolean value) {
        switch (setting) {
            case ILLUMINATED: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DirectionalPressurePlateBlock.LIT, (Comparable)Boolean.valueOf(value)), 3);
                break;
            }
            case SILENT: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DirectionalPressurePlateBlock.SILENT, (Comparable)Boolean.valueOf(!value)), 3);
                break;
            }
            case SHROUDED: {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DirectionalPressurePlateBlock.SHROUDED, (Comparable)Boolean.valueOf(!value)), 3);
            }
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.pressure_plate");
    }

    public boolean permits(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getSettingsValue(PressurePlateSetting.BABY) && !livingEntity.m_6162_()) {
                return false;
            }
        }
        return this.dataStorage.permits(entity, this.getSettingsValue(PressurePlateSetting.WHITELIST));
    }

    public Collection<String> getAllowedValues() {
        return this.dataStorage.getAllowedValues();
    }

    public void setCurrentValues(List<String> values) {
        this.dataStorage.setCurrentValues(values);
        this.m_6596_();
    }

    public List<String> getCurrentValues() {
        return this.dataStorage.getCurrentValues();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(TAG_OWNER)) {
            this.owner = tag.m_128342_(TAG_OWNER);
        }
        this.settings = tag.m_128445_(TAG_SETTINGS);
        this.setSensitivityMaterial(SensitivityMaterial.values()[tag.m_128445_(TAG_MATERIAL)]);
        this.dataStorage.loadFrom(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128362_(TAG_OWNER, this.owner);
        }
        tag.m_128344_(TAG_SETTINGS, (byte)this.settings);
        tag.m_128344_(TAG_MATERIAL, (byte)this.sensitivityMaterial.ordinal());
        this.dataStorage.saveTo(tag);
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new PressurePlateMenu(this.sensitivityMaterial, containerId, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }
}

