/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.world.level.block;

import com.google.common.base.Preconditions;
import fuzs.plentyplates.PlentyPlates;
import fuzs.plentyplates.world.inventory.PressurePlateMenu;
import fuzs.plentyplates.world.level.block.PressurePlateSetting;
import fuzs.plentyplates.world.level.block.entity.data.ColorDataProvider;
import fuzs.plentyplates.world.level.block.entity.data.DataProvider;
import fuzs.plentyplates.world.level.block.entity.data.PlayerDataProvider;
import fuzs.plentyplates.world.level.block.entity.data.RegistryDataProvider;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.ArrayUtils;

public enum SensitivityMaterial {
    OBSIDIAN("obsidian", Blocks.f_50080_, Player.class, new ResourceLocation("block/obsidian"), PlayerDataProvider::new, new PressurePlateSetting[0]),
    COBBLESTONE("cobblestone", Blocks.f_50652_, Entity.class, new ResourceLocation("block/cobblestone"), () -> RegistryDataProvider.entityType(false), new PressurePlateSetting[0]),
    MOSSY_COBBLESTONE("mossy_cobblestone", Blocks.f_50079_, ItemEntity.class, new ResourceLocation("block/mossy_cobblestone"), RegistryDataProvider::item, new PressurePlateSetting[0]),
    STONE_BRICKS("stone_bricks", Blocks.f_50222_, Mob.class, new ResourceLocation("block/stone_bricks"), () -> RegistryDataProvider.entityType(true), PressurePlateSetting.BABY),
    MOSSY_STONE_BRICKS("mossy_stone_bricks", Blocks.f_50223_, Villager.class, new ResourceLocation("block/mossy_stone_bricks"), RegistryDataProvider::villagerProfession, PressurePlateSetting.BABY),
    CHISELED_STONE_BRICKS("chiseled_stone_bricks", Blocks.f_50225_, Sheep.class, new ResourceLocation("block/chiseled_stone_bricks"), ColorDataProvider::new, new PressurePlateSetting[0]);

    private final ResourceLocation id;
    private final Block materialBlock;
    private final Class<? extends Entity> clazz;
    private final ResourceLocation texture;
    private final PressurePlateSetting[] settings;
    public final Supplier<DataProvider<?>> dataProvider;
    private Block pressurePlateBlock;
    private MenuType<PressurePlateMenu> menuType;

    private SensitivityMaterial(String name, Block materialBlock, Class<? extends Entity> clazz, ResourceLocation texture, Supplier<DataProvider<?>> dataProvider, PressurePlateSetting ... settings) {
        this.id = PlentyPlates.id(name + "_pressure_plate");
        this.materialBlock = materialBlock;
        this.clazz = clazz;
        this.texture = texture;
        this.dataProvider = dataProvider;
        this.settings = (PressurePlateSetting[])ArrayUtils.addAll((Object[])PressurePlateSetting.defaultValues(), (Object[])settings);
    }

    public Block getPressurePlateBlock() {
        if (this.pressurePlateBlock == null) {
            Preconditions.checkArgument((boolean)BuiltInRegistries.f_256975_.m_7804_(this.id()));
            this.pressurePlateBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(this.id());
        }
        return this.pressurePlateBlock;
    }

    public MenuType<PressurePlateMenu> getMenuType() {
        if (this.menuType == null) {
            Preconditions.checkArgument((boolean)BuiltInRegistries.f_256818_.m_7804_(this.id()));
            this.menuType = (MenuType)BuiltInRegistries.f_256818_.m_7745_(this.id());
        }
        return this.menuType;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String translationKey() {
        return Util.m_137492_((String)"block", (ResourceLocation)this.id());
    }

    public String descriptionKey() {
        return this.translationKey() + ".entities";
    }

    public ResourceLocation getModelTexture() {
        return this.texture;
    }

    public ResourceLocation getTextureFile() {
        return SensitivityMaterial.expandToFile(this.getModelTexture());
    }

    public ResourceLocation getTranslucentModelTexture() {
        StringBuilder builder = new StringBuilder(this.texture.m_135815_());
        int index = builder.lastIndexOf("/");
        return PlentyPlates.id(builder.insert(++index, "translucent_").toString());
    }

    public ResourceLocation getTranslucentTextureFile() {
        return SensitivityMaterial.expandToFile(this.getTranslucentModelTexture());
    }

    private static ResourceLocation expandToFile(ResourceLocation texture) {
        return new ResourceLocation(texture.m_135827_(), "textures/" + texture.m_135815_() + ".png");
    }

    public Block getMaterialBlock() {
        return this.materialBlock;
    }

    public Class<? extends Entity> getClazz() {
        return this.clazz;
    }

    public PressurePlateSetting[] getSettings() {
        return this.settings;
    }

    public static Block[] allBlocks() {
        return (Block[])Stream.of(SensitivityMaterial.values()).map(SensitivityMaterial::getPressurePlateBlock).toArray(Block[]::new);
    }
}

