/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.world.level.block;

import com.google.common.collect.Maps;
import fuzs.plentyplates.PlentyPlates;
import fuzs.plentyplates.networking.ClientboundInitialValuesMessage;
import fuzs.plentyplates.world.level.block.SensitivityMaterial;
import fuzs.plentyplates.world.level.block.entity.PressurePlateBlockEntity;
import fuzs.plentyplates.world.phys.shapes.VoxelUtils;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DirectionalPressurePlateBlock
extends PressurePlateBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty SHROUDED = BooleanProperty.m_61465_((String)"shrouded");
    public static final BooleanProperty SILENT = BooleanProperty.m_61465_((String)"silent");
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final Vec3[] TOUCH_VECTORS = VoxelUtils.makeVectors(2.0, 0.0, 2.0, 14.0, 4.0, 14.0);
    private static final Vec3[] SHAPE_VECTORS = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, 1.0, 15.0);
    private static final Vec3[] PRESSED_SHAPE_VECTORS = VoxelUtils.makeVectors(1.0, 0.0, 1.0, 15.0, 0.5, 15.0);
    private final Map<Direction, VoxelShape> shapes = (Map)Stream.of(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, SHAPE_VECTORS))));
    private final Map<Direction, VoxelShape> pressedShapes = (Map)Stream.of(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, PRESSED_SHAPE_VECTORS))));
    private final Map<Direction, AABB> touchAABBs = (Map)Stream.of(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), direction -> VoxelUtils.makeCombinedShape(VoxelUtils.rotate(direction, TOUCH_VECTORS)).m_83299_().stream().findAny().orElse(f_49287_)));
    private final SensitivityMaterial sensitivityMaterial;

    public DirectionalPressurePlateBlock(SensitivityMaterial sensitivityMaterial, BlockBehaviour.Properties properties) {
        super(PressurePlateBlock.Sensitivity.EVERYTHING, properties, BlockSetType.f_271479_);
        this.sensitivityMaterial = sensitivityMaterial;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)SHROUDED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SILENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return this.m_6016_(state) > 0 ? this.pressedShapes.get(facing) : this.shapes.get(facing);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockPos).m_60659_((BlockGetter)level, blockPos, direction, SupportType.RIGID) || DirectionalPressurePlateBlock.m_49863_((LevelReader)level, (BlockPos)blockPos, (Direction)direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        for (Direction direction : context.m_6232_()) {
            Direction opposite = direction.m_122424_();
            if (!(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)opposite)).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    protected void playOnSound(LevelAccessor level, BlockPos pos) {
        if (!((Boolean)level.m_8055_(pos).m_61143_((Property)SILENT)).booleanValue()) {
            level.m_247517_((Player)null, pos, BlockSetType.f_271479_.f_271481_(), SoundSource.BLOCKS);
        }
    }

    protected void playOffSound(LevelAccessor level, BlockPos pos) {
        if (!((Boolean)level.m_8055_(pos).m_61143_((Property)SILENT)).booleanValue()) {
            level.m_247517_((Player)null, pos, BlockSetType.f_271479_.f_271234_(), SoundSource.BLOCKS);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = this.m_6016_(state);
        if (i > 0) {
            this.m_152143_(null, (Level)level, pos, state, i);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int i;
        if (!level.f_46443_ && (i = this.m_6016_(state)) == 0) {
            this.m_152143_(entity, level, pos, state, i);
        }
    }

    protected void m_152143_(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int currentSignal) {
        boolean bl2;
        int i = this.m_6693_(level, pos);
        boolean bl = currentSignal > 0;
        boolean bl3 = bl2 = i > 0;
        if (currentSignal != i) {
            BlockState blockState = this.m_7422_(state, i);
            level.m_7731_(pos, blockState, 2);
            this.m_49291_(level, pos);
            level.m_6550_(pos, state, blockState);
        }
        if (!bl2 && bl) {
            this.playOffSound((LevelAccessor)level, pos);
            level.m_142346_(entity, GameEvent.f_223703_, pos);
        } else if (bl2 && !bl) {
            this.playOnSound((LevelAccessor)level, pos);
            level.m_142346_(entity, GameEvent.f_223702_, pos);
        }
        if (bl2) {
            level.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.m_7342_());
        }
    }

    protected int m_6693_(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        AABB aABB = this.touchAABBs.get(state.m_61143_((Property)FACING)).m_82338_(pos);
        List entities = level.m_6443_(this.sensitivityMaterial.getClazz(), aABB, EntitySelector.f_20408_.and(Predicate.not(Entity::m_6090_)).and(entity -> {
            BlockEntity patt8972$temp;
            if (!level.f_46443_ && (patt8972$temp = level.m_7702_(pos)) instanceof PressurePlateBlockEntity) {
                PressurePlateBlockEntity blockEntity = (PressurePlateBlockEntity)patt8972$temp;
                return blockEntity.permits((Entity)entity);
            }
            return false;
        }));
        return !entities.isEmpty() ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction == state.m_61143_((Property)FACING) ? this.m_6016_(state) : 0;
    }

    protected void m_49291_(Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        BlockState state = level.m_8055_(pos);
        level.m_46672_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Block)this);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, SHROUDED, SILENT, LIT});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"block.plentyplates.pressure_plate.activated_by", (Object[])new Object[]{Component.m_237115_((String)this.sensitivityMaterial.descriptionKey()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GREEN));
        if (!ModLoaderEnvironment.INSTANCE.isClient()) {
            return;
        }
        MutableComponent shiftComponent = Component.m_237119_().m_7220_(Proxy.INSTANCE.getKeyMappingComponent("key.sneak")).m_130940_(ChatFormatting.LIGHT_PURPLE);
        MutableComponent useComponent = Component.m_237119_().m_7220_(Proxy.INSTANCE.getKeyMappingComponent("key.use")).m_130940_(ChatFormatting.LIGHT_PURPLE);
        tooltip.add((Component)Component.m_237110_((String)"block.plentyplates.pressure_plate.description", (Object[])new Object[]{shiftComponent, useComponent}).m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PressurePlateBlockEntity(this.sensitivityMaterial, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_36341_()) {
            PressurePlateBlockEntity blockEntity;
            BlockEntity blockEntity2;
            if (!level.f_46443_ && (blockEntity2 = level.m_7702_(pos)) instanceof PressurePlateBlockEntity && (blockEntity = (PressurePlateBlockEntity)blockEntity2).allowedToAccess(player)) {
                player.m_5893_((MenuProvider)blockEntity).ifPresent(containerId -> PlentyPlates.NETWORKING.sendTo((ServerPlayer)player, (Record)new ClientboundInitialValuesMessage(containerId, blockEntity.getAllowedValues(), blockEntity.getCurrentValues())));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

