/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.data;

import com.google.common.base.Preconditions;
import fuzs.plentyplates.world.level.block.DirectionalPressurePlateBlock;
import fuzs.plentyplates.world.level.block.SensitivityMaterial;
import fuzs.puzzleslib.api.data.v1.AbstractModelProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends AbstractModelProvider {
    private final BlockModelProvider blockModels;

    public ModBlockStateProvider(PackOutput packOutput, String modId, ExistingFileHelper fileHelper) {
        super(packOutput, modId, fileHelper);
        this.blockModels = new UncheckedBlockModelProvider(packOutput, modId, fileHelper);
    }

    protected void registerStatesAndModels() {
        for (SensitivityMaterial material : SensitivityMaterial.values()) {
            this.pressurePlateBlock((PressurePlateBlock)material.getPressurePlateBlock(), material.getModelTexture(), material.getTranslucentModelTexture());
            this.itemModels().withExistingParent(this.name(material.getPressurePlateBlock()), this.extendKey(material.getPressurePlateBlock(), new String[]{"block"}));
        }
    }

    public BlockModelProvider models() {
        return this.blockModels;
    }

    public void pressurePlateBlock(PressurePlateBlock block, ResourceLocation texture, ResourceLocation transparentTexture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(this.name((Block)block), texture);
        ModelBuilder pressurePlateDown = this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
        ModelBuilder shroudedPressurePlate = this.models().pressurePlate("shrouded_" + this.name((Block)block), transparentTexture);
        ModelBuilder shroudedPressurePlateDown = this.models().pressurePlateDown("shrouded_" + this.name((Block)block) + "_down", transparentTexture);
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown, (ModelFile)shroudedPressurePlate, (ModelFile)shroudedPressurePlateDown);
    }

    public void pressurePlateBlock(PressurePlateBlock block, ModelFile pressurePlate, ModelFile pressurePlateDown, ModelFile shroudedPressurePlate, ModelFile shroudedPressurePlateDown) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalPressurePlateBlock.FACING);
            boolean powered = (Boolean)state.m_61143_((Property)DirectionalPressurePlateBlock.f_55249_);
            boolean shrouded = (Boolean)state.m_61143_((Property)DirectionalPressurePlateBlock.SHROUDED);
            ModelFile modelFile = shrouded ? (powered ? shroudedPressurePlateDown : shroudedPressurePlate) : (powered ? pressurePlateDown : pressurePlate);
            return ConfiguredModel.builder().modelFile(modelFile).rotationX(facing == Direction.DOWN ? 180 : (facing.m_122434_().m_122479_() ? 90 : 0)).rotationY(facing.m_122434_().m_122478_() ? 0 : ((int)facing.m_122435_() + 180) % 360).build();
        }, new Property[]{DirectionalPressurePlateBlock.WATERLOGGED, DirectionalPressurePlateBlock.SILENT, DirectionalPressurePlateBlock.LIT});
    }

    private static class UncheckedBlockModelProvider
    extends BlockModelProvider {
        protected final Function<ResourceLocation, BlockModelBuilder> factory = resourceLocation -> new UncheckedBlockModelBuilder((ResourceLocation)resourceLocation, fileHelper);

        public UncheckedBlockModelProvider(PackOutput packOutput, String modId, ExistingFileHelper fileHelper) {
            super(packOutput, modId, fileHelper);
        }

        public CompletableFuture<?> m_213708_(CachedOutput output) {
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        protected void registerModels() {
        }

        public BlockModelBuilder getBuilder(String path) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
            ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path));
            this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
            return this.generatedModels.computeIfAbsent(outputLoc, this.factory);
        }

        private ResourceLocation extendWithFolder(ResourceLocation rl) {
            if (rl.m_135815_().contains("/")) {
                return rl;
            }
            return new ResourceLocation(rl.m_135827_(), this.folder + "/" + rl.m_135815_());
        }
    }

    private static class UncheckedBlockModelBuilder
    extends BlockModelBuilder {
        public UncheckedBlockModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
        }

        public UncheckedBlockModelBuilder texture(String key, ResourceLocation texture) {
            Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
            Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
            this.textures.put(key, texture.toString());
            return this;
        }
    }
}

