/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.client.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.plentyplates.world.level.block.SensitivityMaterial;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class TranslucentPackResources
extends AbstractModPackResources {
    private static final Map<ResourceLocation, ResourceLocation> TRANSLUCENT_LOCATIONS = (Map)Stream.of(SensitivityMaterial.values()).collect(ImmutableMap.toImmutableMap(SensitivityMaterial::getTranslucentTextureFile, SensitivityMaterial::getTextureFile));

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        if (packType == PackType.SERVER_DATA) {
            return null;
        }
        if (TRANSLUCENT_LOCATIONS.containsKey(location)) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            return () -> TranslucentPackResources.makeImageTranslucent(resourceManager, location);
        }
        return null;
    }

    private static ByteArrayInputStream makeImageTranslucent(ResourceManager resourceManager, ResourceLocation location) throws IOException {
        try (InputStream inputStream = resourceManager.m_215595_(TRANSLUCENT_LOCATIONS.get(location));){
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                try {
                    for (int x = 0; x < image.m_84982_(); ++x) {
                        for (int y = 0; y < image.m_85084_(); ++y) {
                            int pixel = image.m_84985_(x, y);
                            int alpha = TranslucentPackResources.getA(pixel);
                            if (alpha == 0) continue;
                            image.m_84988_(x, y, pixel & 0xFFFFFF | (int)((double)alpha * 0.25) << 24);
                        }
                    }
                    byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                    if (image == null) break block14;
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                image.close();
            }
            return byteArrayInputStream;
        }
    }

    public static int getA(int abgrColor) {
        return abgrColor >> 24 & 0xFF;
    }

    public Set<String> m_5698_(PackType type) {
        return (Set)TRANSLUCENT_LOCATIONS.keySet().stream().map(ResourceLocation::m_135827_).distinct().collect(ImmutableSet.toImmutableSet());
    }
}

