/*
 * Decompiled with CFR 0.152.
 */
package fuzs.plentyplates.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.plentyplates.PlentyPlates;
import fuzs.plentyplates.client.gui.components.LabelButton;
import fuzs.plentyplates.networking.ServerboundSetValuesMessage;
import fuzs.plentyplates.world.inventory.PressurePlateMenu;
import fuzs.plentyplates.world.level.block.PressurePlateSetting;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.compress.utils.Lists;

public class PressurePlateScreen
extends Screen
implements MenuAccess<PressurePlateMenu>,
ContainerListener {
    public static final ResourceLocation TEXTURE_LOCATION = PlentyPlates.id("textures/gui/pressure_plate.png");
    private static final ResourceLocation BARRIER_LOCATION = new ResourceLocation("item/barrier");
    private static final int VALUES_PER_PAGE = 7;
    private final PressurePlateMenu menu;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EditBox editBox;
    private final LabelButton[] clickableLabels = new LabelButton[7];
    private int selectedLabel = -1;
    private AbstractWidget confirmButton;
    private AbstractWidget removeButton;
    private final AbstractWidget[] navigationButtons = new AbstractWidget[2];
    private List<String> currentValues = Lists.newArrayList();
    private int currentValuesPage;
    private Collection<String> allowedValues = Collections.emptySet();
    private final AbstractWidget[] whitelistButtons = new AbstractWidget[2];

    public PressurePlateScreen(PressurePlateMenu menu, Inventory inventory, Component title) {
        super(title);
        this.menu = menu;
        menu.m_38893_(this);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.editBox != null && this.editBox.f_93624_) {
            this.editBox.m_94120_();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + this.imageWidth - 3 - 21, this.topPos - 18, 15, 15, 203, 0, TEXTURE_LOCATION, button -> this.m_7379_()));
        this.addWhitelistButtons();
        this.addSettingsButtons();
        this.addTextBoxes();
    }

    public void m_7861_() {
        this.menu.m_38943_(this);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.editBox.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.editBox.m_94144_(string);
    }

    private void addWhitelistButtons() {
        int settingsAmount = this.menu.getMaterial().getSettings().length - 1;
        int posX = (this.f_96543_ - settingsAmount * 30 - 20) / 2;
        int posY = this.topPos + 20;
        for (int i = 0; i < this.whitelistButtons.length; ++i) {
            int me = i;
            int other = (i + 1) % 2;
            this.whitelistButtons[i] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(posX, posY, 20, 20, i * 20, 166, 20, TEXTURE_LOCATION, 256, 256, button -> {
                this.sendButtonClick(0);
                this.whitelistButtons[me].f_93624_ = false;
                this.whitelistButtons[other].f_93624_ = true;
            }));
            this.whitelistButtons[i].m_257544_(Tooltip.m_257550_((Component)PressurePlateSetting.WHITELIST.getComponent(me == 0)));
        }
        this.updateWhitelistButtons();
    }

    private void updateWhitelistButtons() {
        if (this.whitelistButtons[0] != null && this.whitelistButtons[1] != null) {
            this.whitelistButtons[0].f_93624_ = this.menu.getSettingsValue(PressurePlateSetting.WHITELIST);
            this.whitelistButtons[1].f_93624_ = !this.menu.getSettingsValue(PressurePlateSetting.WHITELIST);
        }
    }

    private void addSettingsButtons() {
        PressurePlateSetting[] settings = this.menu.getMaterial().getSettings();
        int settingsAmount = settings.length - 1;
        int posX = (this.f_96543_ - settingsAmount * 30 - 20) / 2 + 30;
        int posY = this.topPos + 20;
        int i = 0;
        for (final PressurePlateSetting setting : settings) {
            if (i++ == 0) continue;
            this.m_142416_((GuiEventListener)new ImageButton(posX + (i - 2) * 30, posY, 20, 20, setting.getTextureId() * 20 + 40, 166, TEXTURE_LOCATION, button -> this.sendButtonClick(setting.ordinal())){

                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
                    boolean settingsValue = PressurePlateScreen.this.menu.getSettingsValue(setting);
                    if (!settingsValue) {
                        TextureAtlasSprite atlasSprite = (TextureAtlasSprite)PressurePlateScreen.this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(BARRIER_LOCATION);
                        guiGraphics.m_280159_(this.m_252754_() + 2, this.m_252907_() + 2, 0, 16, 16, atlasSprite);
                    }
                    if (this.m_198029_()) {
                        guiGraphics.m_280557_(PressurePlateScreen.this.f_96547_, setting.getComponent(settingsValue), mouseX, mouseY);
                    }
                }
            });
        }
    }

    private void sendButtonClick(int id) {
        if (this.menu.m_6366_((Player)this.f_96541_.f_91074_, id)) {
            this.f_96541_.f_91072_.m_105208_(this.menu.f_38840_, id);
        }
    }

    private void addTextBoxes() {
        this.editBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 50, 130, 20, (Component)Component.m_237119_()));
        this.editBox.m_94151_(s -> {
            boolean valid;
            this.confirmButton.f_93623_ = valid = this.isValidInput((String)s);
            this.editBox.m_94202_(valid ? 0xE0E0E0 : ChatFormatting.RED.m_126665_());
            String suggestion = valid ? "" : this.allowedValues.stream().filter(Predicate.not(this.currentValues::contains)).filter(value -> value.startsWith((String)s)).map(value -> this.f_96547_.m_92834_(value, this.editBox.m_94210_())).map(value -> value.substring(s.length())).findFirst().orElse("");
            this.editBox.m_94167_(suggestion);
        });
        this.confirmButton = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 147, this.topPos + 50, 20, 20, 140, 166, TEXTURE_LOCATION, button -> {
            String value = this.editBox.m_94155_();
            if (this.isValidInput(value)) {
                this.currentValues.add(value);
                this.sendCurrentValues();
                this.rebuildListView(true);
            }
            this.editBox.m_94144_("");
        }));
        this.confirmButton.f_93623_ = false;
        this.removeButton = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 147, this.topPos + 106, 20, 20, 160, 166, TEXTURE_LOCATION, button -> {
            int index;
            if (this.selectedLabel != -1 && (index = this.currentValuesPage * 7 + this.selectedLabel) >= 0 && index < this.currentValues.size()) {
                this.currentValues.remove(index);
                this.sendCurrentValues();
                this.rebuildListView(false);
            }
        }));
        for (int i = 0; i < this.clickableLabels.length; ++i) {
            int labelIndex = i;
            this.clickableLabels[i] = (LabelButton)this.m_142416_((GuiEventListener)new LabelButton(this.leftPos + 10, this.topPos + 78 + i * 11, 130, 10, (Component)Component.m_237119_(), button -> {
                if (this.selectedLabel != -1 && this.selectedLabel != labelIndex) {
                    this.clickableLabels[this.selectedLabel].reset();
                }
                this.selectedLabel = this.selectedLabel != labelIndex ? labelIndex : -1;
                this.removeButton.f_93623_ = this.selectedLabel != -1;
            }));
        }
        this.navigationButtons[0] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 147, this.topPos + 80, 20, 20, 180, 166, TEXTURE_LOCATION, button -> {
            --this.currentValuesPage;
            this.rebuildListView(false);
        }));
        this.navigationButtons[1] = (AbstractWidget)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 147, this.topPos + 132, 20, 20, 200, 166, TEXTURE_LOCATION, button -> {
            ++this.currentValuesPage;
            this.rebuildListView(false);
        }));
        this.rebuildListView(false);
    }

    private boolean isValidInput(String s) {
        if (s.isBlank()) {
            return false;
        }
        return (this.allowedValues.isEmpty() || this.allowedValues.contains(s)) && !this.currentValues.contains(s);
    }

    private void rebuildListView(boolean scrollToBottom) {
        this.selectedLabel = -1;
        int lastValuesPage = (this.currentValues.size() - 1) / 7;
        if (scrollToBottom || lastValuesPage < this.currentValuesPage) {
            this.currentValuesPage = lastValuesPage;
        }
        this.removeButton.f_93623_ = false;
        for (int i = 0; i < this.clickableLabels.length; ++i) {
            LabelButton clickableLabel = this.clickableLabels[i];
            clickableLabel.reset();
            int index = this.currentValuesPage * 7 + i;
            boolean empty = index >= this.currentValues.size();
            MutableComponent message = empty ? Component.m_237119_() : Component.m_237113_((String)this.currentValues.get(index));
            clickableLabel.m_93666_((Component)message);
            clickableLabel.f_93624_ = !empty;
        }
        this.updateNavigationButtons();
    }

    private void updateNavigationButtons() {
        this.navigationButtons[0].f_93623_ = this.currentValuesPage > 0;
        this.navigationButtons[1].f_93623_ = this.currentValuesPage < (this.currentValues.size() - 1) / 7;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.m_280218_(TEXTURE_LOCATION, this.leftPos + this.imageWidth - 3 - 27, this.topPos - 24, this.imageWidth, 0, 27, 24);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + (this.imageWidth - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2, this.topPos + 6, 0x404040, false);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        if (keyCode == 258 && this.editBox.m_94204_()) {
            int increment = PressurePlateScreen.m_96638_() ? -1 : 1;
            String s = this.editBox.m_94155_();
            if (this.isValidInput(s)) {
                List<String> suggestions = this.allowedValues.stream().filter(Predicate.not(this.currentValues::contains)).toList();
                int index = suggestions.indexOf(s);
                if (index != -1) {
                    this.editBox.m_94144_(suggestions.get(((index + increment) % suggestions.size() + suggestions.size()) % suggestions.size()));
                }
            } else {
                String suggestion = this.allowedValues.stream().filter(Predicate.not(this.currentValues::contains)).filter(value -> value.startsWith(s)).findFirst().orElse(s);
                this.editBox.m_94144_(suggestion);
            }
            return true;
        }
        return this.editBox.m_7933_(keyCode, scanCode, modifiers) || this.editBox.m_94204_() || this.containerKeyPressed(keyCode, scanCode, modifiers);
    }

    public boolean containerKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public PressurePlateMenu getMenu() {
        return this.menu;
    }

    public void m_7934_(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
    }

    public void m_142153_(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        this.updateWhitelistButtons();
    }

    public void setInitialValues(Collection<String> allowedValues, List<String> currentValues) {
        this.allowedValues = allowedValues;
        this.currentValues = currentValues;
        this.rebuildListView(false);
        this.editBox.m_94144_("");
    }

    private void sendCurrentValues() {
        PlentyPlates.NETWORKING.sendToServer((Record)new ServerboundSetValuesMessage(this.menu.f_38840_, this.currentValues));
    }
}

