/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.util;

public class HSPConversionUtil {
    private static final double Pr = 0.299;
    private static final double Pg = 0.587;
    private static final double Pb = 0.114;

    public static double[] RGBtoHSP(double R, double G, double B) {
        double S;
        double H;
        double P = Math.sqrt(R * R * 0.299 + G * G * 0.587 + B * B * 0.114);
        if (R == G && R == B) {
            double H2 = 0.0;
            double S2 = 0.0;
            return new double[]{H2, S2, P};
        }
        if (R >= G && R >= B) {
            if (B >= G) {
                H = 1.0 - 0.16666666666666666 * (B - G) / (R - G);
                S = 1.0 - G / R;
            } else {
                H = 0.0 + 0.16666666666666666 * (G - B) / (R - B);
                S = 1.0 - B / R;
            }
        } else if (G >= R && G >= B) {
            if (R >= B) {
                H = 0.3333333333333333 - 0.16666666666666666 * (R - B) / (G - B);
                S = 1.0 - B / G;
            } else {
                H = 0.3333333333333333 + 0.16666666666666666 * (B - R) / (G - R);
                S = 1.0 - R / G;
            }
        } else if (G >= R) {
            H = 0.6666666666666666 - 0.16666666666666666 * (G - R) / (B - R);
            S = 1.0 - R / B;
        } else {
            H = 0.6666666666666666 + 0.16666666666666666 * (R - G) / (B - G);
            S = 1.0 - G / B;
        }
        return new double[]{H, S, P};
    }

    public static double[] HSPtoRGB(double H, double S, double P) {
        double G;
        double R;
        double B;
        double minOverMax = 1.0 - S;
        if (minOverMax > 0.0) {
            if (H < 0.16666666666666666) {
                H = 6.0 * (H - 0.0);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                B = P / Math.sqrt(0.299 / minOverMax / minOverMax + 0.587 * part * part + 0.114);
                R = B / minOverMax;
                G = B + H * (R - B);
            } else if (H < 0.3333333333333333) {
                H = 6.0 * (-H + 0.3333333333333333);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                B = P / Math.sqrt(0.587 / minOverMax / minOverMax + 0.299 * part * part + 0.114);
                G = B / minOverMax;
                R = B + H * (G - B);
            } else if (H < 0.5) {
                H = 6.0 * (H - 0.3333333333333333);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                R = P / Math.sqrt(0.587 / minOverMax / minOverMax + 0.114 * part * part + 0.299);
                G = R / minOverMax;
                B = R + H * (G - R);
            } else if (H < 0.6666666666666666) {
                H = 6.0 * (-H + 0.6666666666666666);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                R = P / Math.sqrt(0.114 / minOverMax / minOverMax + 0.587 * part * part + 0.299);
                B = R / minOverMax;
                G = R + H * (B - R);
            } else if (H < 0.8333333333333334) {
                H = 6.0 * (H - 0.6666666666666666);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                G = P / Math.sqrt(0.114 / minOverMax / minOverMax + 0.299 * part * part + 0.587);
                B = G / minOverMax;
                R = G + H * (B - G);
            } else {
                H = 6.0 * (-H + 1.0);
                double part = 1.0 + H * (1.0 / minOverMax - 1.0);
                G = P / Math.sqrt(0.299 / minOverMax / minOverMax + 0.114 * part * part + 0.587);
                R = G / minOverMax;
                B = G + H * (R - G);
            }
        } else if (H < 0.16666666666666666) {
            H = 6.0 * (H - 0.0);
            R = Math.sqrt(P * P / (0.299 + 0.587 * H * H));
            G = R * H;
            B = 0.0;
        } else if (H < 0.3333333333333333) {
            H = 6.0 * (-H + 0.3333333333333333);
            G = Math.sqrt(P * P / (0.587 + 0.299 * H * H));
            R = G * H;
            B = 0.0;
        } else if (H < 0.5) {
            H = 6.0 * (H - 0.3333333333333333);
            G = Math.sqrt(P * P / (0.587 + 0.114 * H * H));
            B = G * H;
            R = 0.0;
        } else if (H < 0.6666666666666666) {
            H = 6.0 * (-H + 0.6666666666666666);
            B = Math.sqrt(P * P / (0.114 + 0.587 * H * H));
            G = B * H;
            R = 0.0;
        } else if (H < 0.8333333333333334) {
            H = 6.0 * (H - 0.6666666666666666);
            B = Math.sqrt(P * P / (0.114 + 0.299 * H * H));
            R = B * H;
            G = 0.0;
        } else {
            H = 6.0 * (-H + 1.0);
            R = Math.sqrt(P * P / (0.299 + 0.114 * H * H));
            B = R * H;
            G = 0.0;
        }
        return new double[]{R, G, B};
    }
}

