/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.gui.screens.PixelConfigScreen;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.client.handler.FontColorHandler;
import fuzs.mindfuldarkness.config.ClientConfig;
import fuzs.mindfuldarkness.mixin.client.accessor.AbstractContainerMenuAccessor;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class DaytimeSwitcherHandler {
    public static final ResourceLocation TEXTURE_LOCATION = MindfulDarkness.id("textures/gui/daytime_switcher.png");
    private static AbstractWidget[] buttons;

    public static void onEndTick(Minecraft minecraft) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(minecraft.f_91080_);
    }

    public static void onAfterMouseClick(Screen screen, double mouseX, double mouseY, int button) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(screen);
    }

    private static void setHorizontalButtonPosition(Screen screen) {
        if (buttons == null) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (screen instanceof RecipeUpdateListener) {
                int leftPos = ScreenHelper.INSTANCE.getLeftPos(containerScreen);
                int imageWidth = ScreenHelper.INSTANCE.getImageWidth(containerScreen);
                buttons[0].m_252865_(leftPos + imageWidth - 3 - 21);
                buttons[1].m_252865_(leftPos + imageWidth - 3 - 40);
                buttons[2].m_252865_(leftPos + imageWidth - 3 - 68);
                buttons[3].m_252865_(leftPos + imageWidth - 3 - 95);
            }
        }
    }

    public static EventResult onScreenOpening(@Nullable Screen oldScreen, DefaultedValue<Screen> newScreen) {
        String identifier;
        Screen screen = (Screen)newScreen.get();
        if (screen == null) {
            buttons = null;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (screen != null && ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugAllScreens && (identifier = FontColorHandler.identifyScreen(screen)) != null) {
            MutableComponent message = Component.m_237110_((String)"screen.debug.identifier", (Object[])new Object[]{ComponentUtils.m_130748_((Component)Component.m_237113_((String)identifier))});
            if (minecraft.f_91073_ != null) {
                minecraft.f_91065_.m_93076_().m_93785_((Component)message);
            } else {
                MindfulDarkness.LOGGER.info(message.getString());
            }
        }
        if (screen instanceof AbstractContainerScreen) {
            MenuType<?> type;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugContainerTypes && (type = ((AbstractContainerMenuAccessor)containerScreen.m_6262_()).mindfuldarkness$getMenuType()) != null) {
                MutableComponent component = Component.m_237113_((String)BuiltInRegistries.f_256818_.m_7981_(type).toString());
                MutableComponent message = Component.m_237110_((String)"screen.debug.menuType", (Object[])new Object[]{ComponentUtils.m_130748_((Component)component)});
                minecraft.f_91065_.m_93076_().m_93785_((Component)message);
            }
        }
        return EventResult.PASS;
    }

    public static void onDrawBackground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (DaytimeSwitcherHandler.supportsDaytimeSwitcher(screen)) {
            int leftPos = ScreenHelper.INSTANCE.getLeftPos(screen);
            int topPos = ScreenHelper.INSTANCE.getTopPos(screen);
            int imageWidth = ScreenHelper.INSTANCE.getImageWidth(screen);
            DaytimeSwitcherHandler.drawThemeBg(guiGraphics, leftPos, topPos, imageWidth);
        }
    }

    public static void drawThemeBg(GuiGraphics guiGraphics, int leftPos, int topPos, int imageWidth) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(TEXTURE_LOCATION, leftPos + imageWidth - 3 - 101, topPos - 24, 0.0f, 226.0f, 101, 24, 256, 256);
    }

    private static boolean supportsDaytimeSwitcher(AbstractContainerScreen<?> containerScreen) {
        if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).hideInGameSwitcher) {
            return false;
        }
        if (containerScreen.f_96544_ >= ScreenHelper.INSTANCE.getImageHeight(containerScreen) + 48) {
            if (containerScreen instanceof CreativeModeInventoryScreen) {
                return false;
            }
            MenuType<?> type = ((AbstractContainerMenuAccessor)containerScreen.m_6262_()).mindfuldarkness$getMenuType();
            return type == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).menuBlacklist.contains(type);
        }
        return false;
    }

    public static void onAfterInit(Minecraft minecraft, Screen screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, Consumer<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        AbstractContainerScreen containerScreen;
        if (screen instanceof AbstractContainerScreen && DaytimeSwitcherHandler.supportsDaytimeSwitcher(containerScreen = (AbstractContainerScreen)screen)) {
            int leftPos = ScreenHelper.INSTANCE.getLeftPos(containerScreen);
            int topPos = ScreenHelper.INSTANCE.getTopPos(containerScreen);
            int imageWidth = ScreenHelper.INSTANCE.getImageWidth(containerScreen);
            for (AbstractWidget button : buttons = DaytimeSwitcherHandler.makeButtons(minecraft, screen, leftPos, topPos, imageWidth)) {
                addWidget.accept(button);
            }
        }
    }

    public static AbstractWidget[] makeButtons(Minecraft minecraft, Screen screen, int leftPos, int topPos, int imageWidth) {
        AbstractWidget[] abstractWidgets;
        abstractWidgets = new AbstractWidget[]{new ImageButton(leftPos + imageWidth - 3 - 21, topPos - 18, 15, 15, 224, 0, TEXTURE_LOCATION, button -> screen.m_7379_()), new ImageButton(leftPos + imageWidth - 3 - 40, topPos - 18, 15, 15, 239, 0, TEXTURE_LOCATION, button -> {
            if (screen instanceof PixelConfigScreen) {
                PixelConfigScreen pixelConfigScreen = (PixelConfigScreen)screen;
                pixelConfigScreen.closeToLastScreen();
            } else {
                minecraft.m_91152_((Screen)new PixelConfigScreen(screen));
            }
        }), new ImageButton(leftPos + imageWidth - 3 - 68, topPos - 20, 24, 19, 200, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true)), new ImageButton(leftPos + imageWidth - 3 - 95, topPos - 20, 24, 19, 176, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true))};
        DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], false);
        return abstractWidgets;
    }

    private static void toggleThemeButtons(AbstractWidget lightThemeWidget, AbstractWidget darkThemeWidget, boolean toggleSetting) {
        boolean darkTheme;
        if (toggleSetting) {
            DaytimeSwitcherHandler.activateDaytimeSwitch();
        }
        lightThemeWidget.f_93623_ = darkTheme = ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue();
        darkThemeWidget.f_93623_ = !darkTheme;
    }

    public static void activateDaytimeSwitch() {
        boolean darkTheme = (Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get();
        darkTheme = !darkTheme;
        ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.set((Object)darkTheme);
        ColorChangedAssetsManager.INSTANCE.recordedReset();
    }
}

