/*
 * Decompiled with CFR 0.152.
 */
package fuzs.swordblockingmechanics.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.swordblockingmechanics.SwordBlockingMechanics;
import fuzs.swordblockingmechanics.capability.ParryCooldownCapability;
import fuzs.swordblockingmechanics.config.ServerConfig;
import fuzs.swordblockingmechanics.core.CommonAbstractions;
import fuzs.swordblockingmechanics.init.ModRegistry;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwordBlockingHandler {
    public static final int DEFAULT_ITEM_USE_DURATION = 72000;

    public static EventResultHolder<InteractionResultHolder<ItemStack>> onUseItem(Player player, Level level, InteractionHand hand) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlocking) {
            return EventResultHolder.pass();
        }
        if (player.m_21120_(hand).m_204117_(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG) && (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).prioritizeOffHand || hand != InteractionHand.MAIN_HAND || SwordBlockingHandler.canActivateBlocking(player, player.m_21206_()))) {
            InteractionHand otherHand;
            InteractionHand interactionHand = otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if ((!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).requireBothHands || player.m_21120_(otherHand).m_41619_()) && (double)player.m_36403_(0.0f) >= ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).requiredAttackStrength) {
                player.m_6672_(hand);
                return EventResultHolder.interrupt((Object)InteractionResultHolder.m_19096_((Object)player.m_21120_(hand)));
            }
        }
        return EventResultHolder.pass();
    }

    public static EventResult onUseItemStart(LivingEntity entity, ItemStack stack, MutableInt remainingUseDuration) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlocking) {
            return EventResult.PASS;
        }
        if (entity instanceof Player && stack.m_204117_(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG)) {
            remainingUseDuration.accept(72000);
        }
        return EventResult.PASS;
    }

    public static EventResult onUseItemStop(LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlocking) {
            return EventResult.PASS;
        }
        if (entity instanceof Player && stack.m_204117_(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG)) {
            ModRegistry.PARRY_COOLDOWN_CAPABILITY.maybeGet((Object)entity).ifPresent(ParryCooldownCapability::resetCooldownTicks);
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        ModRegistry.PARRY_COOLDOWN_CAPABILITY.maybeGet((Object)player).ifPresent(ParryCooldownCapability::tick);
    }

    public static EventResult onLivingAttack(LivingEntity entity, DamageSource damageSource, float damageAmount) {
        Player player;
        if (entity.m_9236_().f_46443_ || !(entity instanceof Player) || !SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity)) {
            return EventResult.PASS;
        }
        if (damageAmount > 0.0f && SwordBlockingHandler.canBlockDamageSource(player, damageSource)) {
            boolean parryIsActive;
            boolean bl = parryIsActive = SwordBlockingHandler.getParryStrengthScale(player) > 0.0;
            if (parryIsActive || ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).deflectProjectiles && damageSource.m_269533_(DamageTypeTags.f_268524_)) {
                Entity entity2;
                if (parryIsActive && ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSwordOnParry || !parryIsActive && ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSword) {
                    SwordBlockingHandler.hurtSwordInUse(player, damageAmount);
                }
                if (parryIsActive && !damageSource.m_269533_(DamageTypeTags.f_268524_) && (entity2 = damageSource.m_7640_()) instanceof LivingEntity) {
                    LivingEntity directEntity = (LivingEntity)entity2;
                    directEntity.m_147240_(((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryKnockbackStrength, player.m_20185_() - directEntity.m_20185_(), player.m_20189_() - directEntity.m_20189_());
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModRegistry.ITEM_SWORD_BLOCK_SOUND_EVENT.get(), player.m_5720_(), 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        Player player;
        if (entity instanceof Player && SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity) && SwordBlockingHandler.canBlockDamageSource(player, source) && amount.getAsFloat() > 0.0f) {
            if (((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSword) {
                SwordBlockingHandler.hurtSwordInUse(player, amount.getAsFloat());
            }
            double damageAfterBlock = 1.0 + (double)amount.getAsFloat() * (1.0 - ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).blockedDamage);
            amount.mapFloat(v -> Float.valueOf(Math.min(v.floatValue(), (float)Math.floor(damageAfterBlock))));
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingKnockBack(LivingEntity entity, DefaultedDouble strength, DefaultedDouble ratioX, DefaultedDouble ratioZ) {
        Player player;
        if (entity instanceof Player && SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity)) {
            float knockBackMultiplier = 1.0f - (float)((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).knockbackReduction;
            if (knockBackMultiplier == 0.0f) {
                return EventResult.INTERRUPT;
            }
            strength.mapDouble(v -> v * (double)knockBackMultiplier);
        }
        return EventResult.PASS;
    }

    private static boolean canBlockDamageSource(Player player, DamageSource source) {
        Vec3 position;
        AbstractArrow arrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
            return false;
        }
        if (!source.m_269533_(DamageTypeTags.f_268490_) && (position = source.m_7270_()) != null) {
            Vec3 viewVector = player.m_20252_(1.0f);
            position = position.m_82505_(player.m_20182_()).m_82541_();
            position = new Vec3(position.f_82479_, 0.0, position.f_82481_);
            return position.m_82526_(viewVector) < -Math.cos(((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).protectionArc * Math.PI * 0.5 / 180.0);
        }
        return false;
    }

    public static boolean isActiveItemStackBlocking(Player player) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlocking) {
            return false;
        }
        return player.m_6117_() && player.m_21211_().m_204117_(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG);
    }

    public static double getParryStrengthScale(Player player) {
        Optional<ParryCooldownCapability> optional = ModRegistry.PARRY_COOLDOWN_CAPABILITY.maybeGet((Object)player).filter(ParryCooldownCapability::isCooldownActive);
        if (optional.isPresent()) {
            return -optional.orElseThrow().getCooldownProgress();
        }
        if (SwordBlockingHandler.isActiveItemStackBlocking(player)) {
            double currentUseDuration = 72000 - player.m_21212_();
            double parryStrengthScale = 1.0 - currentUseDuration / (double)((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryWindow;
            return Mth.m_14008_((double)parryStrengthScale, (double)0.0, (double)1.0);
        }
        return 0.0;
    }

    private static void hurtSwordInUse(Player player, float damageAmount) {
        if (damageAmount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)damageAmount);
            InteractionHand interactionhand = player.m_7655_();
            player.m_21211_().m_41622_(i, (LivingEntity)player, t -> {
                t.m_21190_(interactionhand);
                CommonAbstractions.INSTANCE.onPlayerDestroyItem((Player)t, t.m_21211_(), interactionhand);
            });
            if (player.m_21211_().m_41619_()) {
                if (interactionhand == InteractionHand.MAIN_HAND) {
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                player.m_5810_();
                player.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public static boolean canActivateBlocking(Player player, ItemStack stack) {
        if (stack.m_204117_(ModRegistry.OVERRIDES_SWORD_IN_OFFHAND_BLOCKING_ITEM_TAG)) {
            return false;
        }
        return switch (stack.m_41780_()) {
            case UseAnim.BLOCK, UseAnim.SPYGLASS, UseAnim.BRUSH -> false;
            case UseAnim.EAT, UseAnim.DRINK -> {
                if (stack.m_41720_().m_41473_() == null || !player.m_36391_(stack.m_41720_().m_41473_().m_38747_())) {
                    yield true;
                }
                yield false;
            }
            case UseAnim.BOW, UseAnim.CROSSBOW -> player.m_6298_(stack).m_41619_();
            case UseAnim.SPEAR -> {
                if (stack.m_41773_() >= stack.m_41776_() - 1 || EnchantmentHelper.m_44932_((ItemStack)stack) > 0 && !player.m_20070_()) {
                    yield true;
                }
                yield false;
            }
            case UseAnim.TOOT_HORN -> player.m_36335_().m_41519_(stack.m_41720_());
            default -> true;
        };
    }
}

