/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    private static final String FLAT_TOP_TAG = "flatTop";
    private static final String MATERIALS_TAG = "materials";

    public BarrelBlockItem(Block block) {
        this(block, new Item.Properties());
    }

    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(ItemStack stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop(stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(ItemStack stack, boolean flatTop) {
        if (flatTop) {
            NBTHelper.setBoolean((ItemStack)stack, (String)FLAT_TOP_TAG, (boolean)true);
        } else {
            NBTHelper.removeTag((ItemStack)stack, (String)FLAT_TOP_TAG);
        }
    }

    public static boolean isFlatTop(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)FLAT_TOP_TAG).orElse(false);
    }

    public static void setMaterials(ItemStack barrel, Map<BarrelMaterial, ResourceLocation> materials) {
        NBTHelper.putMap((CompoundTag)barrel.m_41784_(), (String)MATERIALS_TAG, materials, BarrelMaterial::m_7912_, resourceLocation -> StringTag.m_129297_((String)resourceLocation.toString()));
    }

    public static Map<BarrelMaterial, ResourceLocation> getMaterials(ItemStack barrel) {
        return NBTHelper.getMap((ItemStack)barrel, (String)MATERIALS_TAG, BarrelMaterial::fromName, (bm, tag) -> Optional.of(new ResourceLocation(tag.m_7916_()))).orElse(Map.of());
    }

    public static void removeMaterials(ItemStack stack) {
        NBTHelper.removeTag((ItemStack)stack, (String)MATERIALS_TAG);
    }

    public static void uncompactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        if (materials.isEmpty()) {
            return;
        }
        EnumMap uncompactedMaterials = new EnumMap(BarrelMaterial.class);
        materials.forEach((mat, texture) -> {
            for (BarrelMaterial child : mat.getChildren()) {
                uncompactedMaterials.put(child, texture);
            }
        });
        materials.clear();
        materials.putAll(uncompactedMaterials);
    }

    public static void compactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        for (BarrelMaterial material : BarrelMaterial.values()) {
            if (material.isLeaf()) continue;
            ResourceLocation firstChildTexture = null;
            boolean allChildrenHaveSameTexture = true;
            for (BarrelMaterial child : material.getChildren()) {
                ResourceLocation texture = materials.get((Object)child);
                if (texture == null || firstChildTexture != null && !firstChildTexture.equals((Object)texture)) {
                    allChildrenHaveSameTexture = false;
                    break;
                }
                if (firstChildTexture != null) continue;
                firstChildTexture = texture;
            }
            if (firstChildTexture == null || !allChildrenHaveSameTexture) continue;
            materials.put(material, firstChildTexture);
            for (BarrelMaterial child : material.getChildren()) {
                materials.remove((Object)child);
            }
        }
    }

    public static void removeCoveredTints(ItemStack barrelStackCopy, Map<BarrelMaterial, ResourceLocation> materials) {
        Item item = barrelStackCopy.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            boolean hasMainTint = tintableBlockItem.getMainColor(barrelStackCopy).isPresent();
            boolean hasAccentTint = tintableBlockItem.getAccentColor(barrelStackCopy).isPresent();
            if (hasMainTint || hasAccentTint) {
                if (hasMainTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_BUT_TRIM))) {
                    tintableBlockItem.removeMainColor(barrelStackCopy);
                }
                if (hasAccentTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_TRIM))) {
                    tintableBlockItem.removeAccentColor(barrelStackCopy);
                }
            }
        }
    }

    public static Map<BarrelMaterial, ResourceLocation> getUncompactedMaterials(ItemStack storageStack) {
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(storageStack));
        BarrelBlockItem.uncompactMaterials(materials);
        return materials;
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        Component name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.m_7626_(stack) : BarrelBlockItem.getDisplayName(this.m_5524_(), null);
        if (BarrelBlockItem.isFlatTop(stack)) {
            return name.m_6881_().m_7220_((Component)Component.m_237115_((String)(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top")));
        }
        return name;
    }

    @Override
    public boolean isTintable(ItemStack stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

