/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class DoubleChestTierUpgradeShapelessRecipe
extends ShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapelessRecipe compose;

    public DoubleChestTierUpgradeShapelessRecipe(ShapelessRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.f_44243_, compose.m_7527_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return super.m_5818_(inv, level) && this.getOriginalStorage(inv).isPresent();
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registries) {
        ItemStack upgradedStorage = super.m_5874_(inv, registries);
        this.getOriginalStorage(inv).ifPresent(originalStorage -> upgradedStorage.m_41751_(originalStorage.m_41783_()));
        if (StorageBlockItem.getContentsUuid(upgradedStorage).isPresent()) {
            StackStorageWrapper storageWrapper = new StackStorageWrapper(upgradedStorage);
            StorageBlockItem.setNumberOfInventorySlots(upgradedStorage, storageWrapper.getDefaultNumberOfInventorySlots() * 2);
            StorageBlockItem.setNumberOfUpgradeSlots(upgradedStorage, storageWrapper.getDefaultNumberOfUpgradeSlots() * 2);
        }
        return upgradedStorage;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getOriginalStorage(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (!(slotStack.m_41720_() instanceof ChestBlockItem) || !ChestBlockItem.isDoubleChest(slotStack)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.DOUBLE_CHEST_TIER_UPGRADE_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, DoubleChestTierUpgradeShapelessRecipe> {
        public Serializer() {
            super(DoubleChestTierUpgradeShapelessRecipe::new, RecipeSerializer.f_44077_);
        }
    }
}

