/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.ICompat;
import net.brnbrd.delightful.compat.Modid;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class DKnifeItem
extends KnifeItem
implements ICompat {
    @Nullable
    private final TagKey<Item> tag;
    @NotNull
    private final Modid[] modid;

    public DKnifeItem(@Nullable TagKey<Item> tag, Tier tier, Item.Properties properties) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = tag;
        this.modid = Util.EMPTY;
    }

    public DKnifeItem(@Nullable TagKey<Item> tag, Tier tier, Item.Properties properties, Modid ... modid) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = tag;
        this.modid = modid;
    }

    public DKnifeItem(Tier tier, Item.Properties properties) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = null;
        this.modid = Util.EMPTY;
    }

    @Override
    @Nullable
    public TagKey<Item> getDependencyTag() {
        return this.tag;
    }

    @Override
    public Modid[] getModid() {
        return this.modid;
    }

    public List<Component> getTools() {
        return Collections.emptyList();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(stack, level, comps, pIsAdvanced);
        if (this.enabled() && !this.getTools().isEmpty()) {
            comps.addAll(this.getTools());
        }
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, @NotNull ItemStack pRepair) {
        return this.enabled() && super.m_6832_(pToRepair, pRepair);
    }

    public Ingredient getRod() {
        return Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN);
    }

    @NotNull
    public ItemStack getCreativeItem() {
        return new ItemStack((ItemLike)this);
    }

    @Nullable
    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44107_;
    }

    @Nullable
    public Lazy<Multimap<Attribute, AttributeModifier>> getModifiers(EquipmentSlot slot, ItemStack stack) {
        return null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap mods = super.getAttributeModifiers(slot, stack);
        Lazy<Multimap<Attribute, AttributeModifier>> additional = this.getModifiers(slot, stack);
        if (this.enabled() && slot == EquipmentSlot.MAINHAND && additional != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (!mods.isEmpty()) {
                builder.putAll(mods);
            }
            builder.putAll((Multimap)additional.get());
            return builder.build();
        }
        return mods;
    }

    public String getTranslation() {
        return StringUtils.capitaliseAllWords((String)this.m_5524_().toLowerCase(Locale.ROOT).replace("item." + "delightful".toLowerCase(Locale.ROOT) + ".", "").replace("_", " "));
    }
}

