/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.fences;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.item.BlockItemFuel;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryObject;

public class Fences {
    private static BlockBehaviour.Properties wood = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_);
    private static BlockBehaviour.Properties leaves = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_);
    private static BlockBehaviour.Properties stone = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_);
    public static final String modid = "mcwfences";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationWoodModLoaded(set, block, item, tab, "minecraft", wood);
    }

    public static void setRegistrationHedges(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationHedgesModLoaded(leaves, block, item, tab, "minecraft", Fences.leaves);
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationRockModLoaded(rock, block, item, tab, "minecraft", stone);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        for (String i : set) {
            try {
                RegistryObject<Block> pyramid_gate;
                RegistryObject<Block> highley_gate;
                RegistryObject<Block> wired_fence;
                RegistryObject<Block> horse_fence;
                RegistryObject<Block> stockade_fence;
                RegistryObject<Block> picket_fence;
                if (ModList.get().isLoaded(modid)) {
                    picket_fence = Fences.createBlock(i + "_picket_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                    stockade_fence = Fences.createBlock(i + "_stockade_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                    horse_fence = Fences.createBlock(i + "_horse_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                    wired_fence = Fences.createBlock(i + "_wired_fence", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.WiredFence", WOOD), block, item, tab, modLoaded);
                    highley_gate = Fences.createBlock(i + "_highley_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
                    pyramid_gate = Fences.createBlock(i + "_pyramid_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
                    continue;
                }
                picket_fence = Fences.createBlock(i + "_picket_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                stockade_fence = Fences.createBlock(i + "_stockade_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                horse_fence = Fences.createBlock(i + "_horse_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                wired_fence = Fences.createBlock(i + "_wired_fence", () -> new FenceBlock(WOOD), block, item, tab, modLoaded);
                highley_gate = Fences.createBlock(i + "_highley_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
                pyramid_gate = Fences.createBlock(i + "_pyramid_gate", () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setRegistrationHedgesModLoaded(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties HEDGES = prop;
        for (String i : leaves) {
            RegistryObject<Block> hedge;
            if (ModList.get().isLoaded(modid)) {
                hedge = Fences.createBlock(i + "_hedge", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", HEDGES), block, item, tab, modLoaded);
                continue;
            }
            hedge = Fences.createBlock(i + "_hedge", () -> new FenceBlock(HEDGES), block, item, tab, modLoaded);
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        for (String i : rock) {
            RegistryObject<Block> grass_topped_wall;
            RegistryObject<Block> pillar_wall;
            RegistryObject<Block> railing_gate;
            RegistryObject<Block> railing_wall;
            RegistryObject<Block> modern_wall;
            if (ModList.get().isLoaded(modid)) {
                modern_wall = Fences.createBlockStone("modern_" + i + "_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
                railing_wall = Fences.createBlockStone("railing_" + i + "_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
                railing_gate = Fences.createBlockStone(i + "_railing_gate", () -> new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
                pillar_wall = Fences.createBlockStone(i + "_pillar_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
                grass_topped_wall = Fences.createBlock(i + "_grass_topped_wall", () -> Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", STONE), block, item, tab, modLoaded);
                continue;
            }
            modern_wall = Fences.createBlockStone("modern_" + i + "_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
            railing_wall = Fences.createBlockStone("railing_" + i + "_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
            railing_gate = Fences.createBlockStone(i + "_railing_gate", () -> new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item, tab, modLoaded);
            pillar_wall = Fences.createBlockStone(i + "_pillar_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
            grass_topped_wall = Fences.createBlockStone(i + "_grass_topped_wall", () -> new FenceBlock(STONE), block, item, tab, modLoaded);
        }
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab) {
        return Fences.createBlock(name, supplier, BLOCKS_REGISTRY, ITEMS_REGISTRY, tab, "minecraft");
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab, String modLoaded) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        if (ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
        } else {
            ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab) {
        return Fences.createBlockStone(name, supplier, BLOCKS_REGISTRY, ITEMS_REGISTRY, tab, "minecraft");
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab, String modLoaded) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        if (ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        } else {
            ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static void registryWood(NewRegistryEvent event, List<String> set, CreativeModeTab tab) {
        BlockBehaviour.Properties WOOD = wood;
        for (String i : set) {
            try {
                Block pyramid_gate;
                Block highley_gate;
                Block wired_fence;
                Block horse_fence;
                Block stockade_fence;
                Block picket_fence;
                if (ModList.get().isLoaded(modid)) {
                    picket_fence = Fences.createBlockWoodOpti(i + "_picket_fence", (Block)new FenceBlock(WOOD), tab);
                    stockade_fence = Fences.createBlockWoodOpti(i + "_stockade_fence", (Block)new FenceBlock(WOOD), tab);
                    horse_fence = Fences.createBlockWoodOpti(i + "_horse_fence", (Block)new FenceBlock(WOOD), tab);
                    wired_fence = Fences.createBlockWoodOpti(i + "_wired_fence", Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.WiredFence", WOOD), tab);
                    highley_gate = Fences.createBlockWoodOpti(i + "_highley_gate", (Block)new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
                    pyramid_gate = Fences.createBlockWoodOpti(i + "_pyramid_gate", (Block)new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
                    continue;
                }
                picket_fence = Fences.createBlockWoodOpti(i + "_picket_fence", (Block)new FenceBlock(WOOD), tab);
                stockade_fence = Fences.createBlockWoodOpti(i + "_stockade_fence", (Block)new FenceBlock(WOOD), tab);
                horse_fence = Fences.createBlockWoodOpti(i + "_horse_fence", (Block)new FenceBlock(WOOD), tab);
                wired_fence = Fences.createBlockWoodOpti(i + "_wired_fence", (Block)new FenceBlock(WOOD), tab);
                highley_gate = Fences.createBlockWoodOpti(i + "_highley_gate", (Block)new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
                pyramid_gate = Fences.createBlockWoodOpti(i + "_pyramid_gate", (Block)new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void registryHedges(NewRegistryEvent event, List<String> leaves, CreativeModeTab tab) {
        BlockBehaviour.Properties HEDGES = Fences.leaves;
        for (String i : leaves) {
            Block hedge;
            if (ModList.get().isLoaded(modid)) {
                hedge = Fences.createBlockWoodOpti(i + "_hedge", Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", HEDGES), tab);
                continue;
            }
            hedge = Fences.createBlockWoodOpti(i + "_hedge", (Block)new FenceBlock(HEDGES), tab);
        }
    }

    public static void registryStone(NewRegistryEvent event, List<String> rock, CreativeModeTab tab) {
        BlockBehaviour.Properties STONE = stone;
        for (String i : rock) {
            Block grass_topped_wall;
            Block pillar_wall;
            Block railing_gate;
            Block railing_wall;
            Block modern_wall;
            if (ModList.get().isLoaded(modid)) {
                modern_wall = Fences.createBlockStoneOpti("modern_" + i + "_wall", (Block)new FenceBlock(STONE), tab);
                railing_wall = Fences.createBlockStoneOpti("railing_" + i + "_wall", (Block)new FenceBlock(STONE), tab);
                railing_gate = Fences.createBlockStoneOpti(i + "_railing_gate", (Block)new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
                pillar_wall = Fences.createBlockStoneOpti(i + "_pillar_wall", (Block)new FenceBlock(STONE), tab);
                grass_topped_wall = Fences.createBlockStoneOpti(i + "_grass_topped_wall", Registration.getBlocksFieldForFences("com.mcwfences.kikoz.objects.FenceHitbox", STONE), tab);
                continue;
            }
            modern_wall = Fences.createBlockStoneOpti("modern_" + i + "_wall", (Block)new FenceBlock(STONE), tab);
            railing_wall = Fences.createBlockStoneOpti("railing_" + i + "_wall", (Block)new FenceBlock(STONE), tab);
            railing_gate = Fences.createBlockStoneOpti(i + "_railing_gate", (Block)new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), tab);
            pillar_wall = Fences.createBlockStoneOpti(i + "_pillar_wall", (Block)new FenceBlock(STONE), tab);
            grass_topped_wall = Fences.createBlockStoneOpti(i + "_grass_topped_wall", (Block)new FenceBlock(STONE), tab);
        }
    }

    protected static Block createBlockWoodOpti(String name, Block block, CreativeModeTab tab) {
        BlockItemFuel itemBlock = ModList.get().isLoaded(modid) ? new BlockItemFuel(block, new Item.Properties()) : new BlockItem(block, new Item.Properties());
        ForgeRegistries.BLOCKS.register(name, (Object)block);
        ForgeRegistries.ITEMS.register(name, (Object)itemBlock);
        return block;
    }

    protected static Block createBlockStoneOpti(String name, Block block, CreativeModeTab tab) {
        BlockItem itemBlock = ModList.get().isLoaded(modid) ? new BlockItem(block, new Item.Properties()) : new BlockItem(block, new Item.Properties());
        ForgeRegistries.BLOCKS.register(name, (Object)block);
        ForgeRegistries.ITEMS.register(name, (Object)itemBlock);
        return block;
    }

    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block picket_fence = Finder.findBlock(MODID, i + "_picket_fence");
                Block stockade_fence = Finder.findBlock(MODID, i + "_stockade_fence");
                Block horse_fence = Finder.findBlock(MODID, i + "_horse_fence");
                Block wired_fence = Finder.findBlock(MODID, i + "_wired_fence");
                Block highley_gate = Finder.findBlock(MODID, i + "_highley_gate");
                Block pyramid_gate = Finder.findBlock(MODID, i + "_pyramid_gate");
                event.m_246326_((ItemLike)picket_fence);
                event.m_246326_((ItemLike)stockade_fence);
                event.m_246326_((ItemLike)horse_fence);
                event.m_246326_((ItemLike)wired_fence);
                event.m_246326_((ItemLike)highley_gate);
                event.m_246326_((ItemLike)pyramid_gate);
            }
        }
    }

    public static void addToTabHedge(BuildCreativeModeTabContentsEvent event, String MODID, List<String> LEAVES, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : LEAVES) {
                Block hedge = Finder.findBlock(MODID, i + "_hedge");
                event.m_246326_((ItemLike)hedge);
            }
        }
    }

    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : STONE) {
                Block modern_wall = Finder.findBlock(MODID, "modern_" + i + "_wall");
                Block railing_wall = Finder.findBlock(MODID, "railing_" + i + "_wall");
                Block railing_gate = Finder.findBlock(MODID, i + "_railing_gate");
                Block pillar_wall = Finder.findBlock(MODID, i + "_pillar_wall");
                Block grass_topped_wall = Finder.findBlock(MODID, i + "_grass_topped_wall");
                event.m_246326_((ItemLike)modern_wall);
                event.m_246326_((ItemLike)railing_wall);
                event.m_246326_((ItemLike)railing_gate);
                event.m_246326_((ItemLike)pillar_wall);
                event.m_246326_((ItemLike)grass_topped_wall);
            }
        }
    }
}

