/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.item.BlockItemFuel;
import fr.samlegamer.addonslib.item.BlockItemFuelInfo;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryObject;

public class Bridges {
    private static BlockBehaviour.Properties wood = BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 2.5f).m_60918_(SoundType.f_56736_);
    private static BlockBehaviour.Properties stone = BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56742_);
    public static final String modid = "mcwbridges";
    private static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Bridges.setRegistrationWoodModLoaded(set, block, item, tab, "minecraft", wood);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Bridges.setRegistrationRockModLoaded(set, block, item, tab, "minecraft", stone);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        for (String i : set) {
            try {
                RegistryObject<Block> balustrade_cryptic_stone_bridge;
                RegistryObject<Block> cryptic_stone_bridge_stair;
                RegistryObject<Block> cryptic_stone_bridge_pier;
                RegistryObject<Block> cryptic_stone_bridge;
                if (ModList.get().isLoaded(modid)) {
                    cryptic_stone_bridge = Bridges.createBlockStone(i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), block, item, tab, modLoaded);
                    cryptic_stone_bridge_pier = Bridges.createBlockStone(i + "_bridge_pier", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", STONE), block, item, tab, modLoaded);
                    cryptic_stone_bridge_stair = Bridges.createBlockStone(i + "_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", STONE), block, item, tab, modLoaded);
                    balustrade_cryptic_stone_bridge = Bridges.createBlockStone("balustrade_" + i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), block, item, tab, modLoaded);
                    continue;
                }
                cryptic_stone_bridge = Bridges.createBlockStone(i + "_bridge", () -> new Block(STONE), block, item, tab, modLoaded);
                cryptic_stone_bridge_pier = Bridges.createBlockStone(i + "_bridge_pier", () -> new Block(STONE), block, item, tab, modLoaded);
                cryptic_stone_bridge_stair = Bridges.createBlockStone(i + "_bridge_stair", () -> new Block(STONE), block, item, tab, modLoaded);
                balustrade_cryptic_stone_bridge = Bridges.createBlockStone("balustrade_" + i + "_bridge", () -> new Block(STONE), block, item, tab, modLoaded);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        BlockBehaviour.Properties RAILS = prop.m_60955_();
        for (String i : set) {
            try {
                RegistryObject<Block> rail_bridge;
                RegistryObject<Block> rope_bridge_stair;
                RegistryObject<Block> log_bridge_stair;
                RegistryObject<Block> bridge_pier;
                RegistryObject<Block> rope_bridge;
                RegistryObject<Block> log_bridge_middle;
                if (ModList.get().isLoaded(modid)) {
                    log_bridge_middle = Bridges.createBlock(i + "_log_bridge_middle", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Log_Bridge", WOOD), block, item, tab, modLoaded);
                    rope_bridge = Bridges.createBlock("rope_" + i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block_Rope", WOOD), block, item, tab, modLoaded);
                    bridge_pier = Bridges.createBlock(i + "_bridge_pier", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", WOOD), block, item, tab, modLoaded);
                    log_bridge_stair = Bridges.createBlock(i + "_log_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), block, item, tab, modLoaded);
                    rope_bridge_stair = Bridges.createBlock(i + "_rope_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), block, item, tab, modLoaded);
                    rail_bridge = Bridges.createBlock(i + "_rail_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Rail_Bridge", WOOD), block, item, tab, modLoaded);
                    continue;
                }
                log_bridge_middle = Bridges.createBlock(i + "_log_bridge_middle", () -> new Block(WOOD), block, item, tab, modLoaded);
                rope_bridge = Bridges.createBlock("rope_" + i + "_bridge", () -> new Block(WOOD), block, item, tab, modLoaded);
                bridge_pier = Bridges.createBlock(i + "_bridge_pier", () -> new Block(WOOD), block, item, tab, modLoaded);
                log_bridge_stair = Bridges.createBlock(i + "_log_bridge_stair", () -> new Block(WOOD), block, item, tab, modLoaded);
                rope_bridge_stair = Bridges.createBlock(i + "_rope_bridge_stair", () -> new Block(WOOD), block, item, tab, modLoaded);
                rail_bridge = Bridges.createBlock(i + "_rail_bridge", () -> new Block(RAILS), block, item, tab, modLoaded);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab, String modLoaded) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        if (ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            if (name.contains("log_bridge_middle") || name.startsWith("rope_")) {
                ITEMS_REGISTRY.register(name, () -> new BlockItemFuelInfo((Block)block.get(), new Item.Properties(), desc));
            } else {
                ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
            }
        } else {
            ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab) {
        return Bridges.createBlock(name, supplier, BLOCKS_REGISTRY, ITEMS_REGISTRY, tab, "minecraft");
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab) {
        return Bridges.createBlock(name, supplier, BLOCKS_REGISTRY, ITEMS_REGISTRY, tab, "minecraft");
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY, CreativeModeTab tab, String modLoaded) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        if (ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        } else {
            ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static void registryWood(NewRegistryEvent event, List<String> WOODS, CreativeModeTab tab) {
        BlockBehaviour.Properties WOOD = wood;
        BlockBehaviour.Properties RAILS = wood.m_60955_();
        for (String i : WOODS) {
            try {
                Block rail_bridge;
                Block rope_bridge_stair;
                Block log_bridge_stair;
                Block bridge_pier;
                Block rope_bridge;
                Block log_bridge_middle;
                if (ModList.get().isLoaded(modid)) {
                    log_bridge_middle = Bridges.createBlockWoodOpti(i + "_log_bridge_middle", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Log_Bridge", WOOD), tab);
                    rope_bridge = Bridges.createBlockWoodOpti("rope_" + i + "_bridge", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block_Rope", WOOD), tab);
                    bridge_pier = Bridges.createBlockWoodOpti(i + "_bridge_pier", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", WOOD), tab);
                    log_bridge_stair = Bridges.createBlockWoodOpti(i + "_log_bridge_stair", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), tab);
                    rope_bridge_stair = Bridges.createBlockWoodOpti(i + "_rope_bridge_stair", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), tab);
                    rail_bridge = Bridges.createBlockWoodOpti(i + "_rail_bridge", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Rail_Bridge", WOOD), tab);
                    continue;
                }
                log_bridge_middle = Bridges.createBlockWoodOpti(i + "_log_bridge_middle", new Block(WOOD), tab);
                rope_bridge = Bridges.createBlockWoodOpti("rope_" + i + "_bridge", new Block(WOOD), tab);
                bridge_pier = Bridges.createBlockWoodOpti(i + "_bridge_pier", new Block(WOOD), tab);
                log_bridge_stair = Bridges.createBlockWoodOpti(i + "_log_bridge_stair", new Block(WOOD), tab);
                rope_bridge_stair = Bridges.createBlockWoodOpti(i + "_rope_bridge_stair", new Block(WOOD), tab);
                rail_bridge = Bridges.createBlockWoodOpti(i + "_rail_bridge", new Block(RAILS), tab);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void registryStone(NewRegistryEvent event, List<String> STONES, CreativeModeTab tab) {
        BlockBehaviour.Properties STONE = stone;
        for (String i : STONES) {
            try {
                Block balustrade_cryptic_stone_bridge;
                Block cryptic_stone_bridge_stair;
                Block cryptic_stone_bridge_pier;
                Block cryptic_stone_bridge;
                if (ModList.get().isLoaded(modid)) {
                    cryptic_stone_bridge = Bridges.createBlockStoneOpti(i + "_bridge", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), tab);
                    cryptic_stone_bridge_pier = Bridges.createBlockStoneOpti(i + "_bridge_pier", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", STONE), tab);
                    cryptic_stone_bridge_stair = Bridges.createBlockStoneOpti(i + "_bridge_stair", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", STONE), tab);
                    balustrade_cryptic_stone_bridge = Bridges.createBlockStoneOpti("balustrade_" + i + "_bridge", Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), tab);
                    continue;
                }
                cryptic_stone_bridge = Bridges.createBlockStoneOpti(i + "_bridge", new Block(STONE), tab);
                cryptic_stone_bridge_pier = Bridges.createBlockStoneOpti(i + "_bridge_pier", new Block(STONE), tab);
                cryptic_stone_bridge_stair = Bridges.createBlockStoneOpti(i + "_bridge_stair", new Block(STONE), tab);
                balustrade_cryptic_stone_bridge = Bridges.createBlockStoneOpti("balustrade_" + i + "_bridge", new Block(STONE), tab);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static Block createBlockWoodOpti(String name, Block block, CreativeModeTab tab) {
        BlockItem itemBlock = ModList.get().isLoaded(modid) ? (name.contains("log_bridge_middle") || name.startsWith("rope_") ? new BlockItemFuelInfo(block, new Item.Properties(), desc) : new BlockItemFuel(block, new Item.Properties())) : new BlockItemFuel(block, new Item.Properties());
        ForgeRegistries.BLOCKS.register(name, (Object)block);
        ForgeRegistries.ITEMS.register(name, (Object)itemBlock);
        return block;
    }

    protected static Block createBlockStoneOpti(String name, Block block, CreativeModeTab tab) {
        BlockItem itemBlock = ModList.get().isLoaded(modid) ? new BlockItem(block, new Item.Properties()) : new BlockItem(block, new Item.Properties());
        ForgeRegistries.BLOCKS.register(name, (Object)block);
        ForgeRegistries.ITEMS.register(name, (Object)itemBlock);
        return block;
    }

    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : WOOD) {
                Block log_bridge_middle = Finder.findBlock(MODID, i + "_log_bridge_middle");
                Block rope_bridge = Finder.findBlock(MODID, "rope_" + i + "_bridge");
                Block bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block log_bridge_stair = Finder.findBlock(MODID, i + "_log_bridge_stair");
                Block rope_bridge_stair = Finder.findBlock(MODID, i + "_rope_bridge_stair");
                Block rail_bridge = Finder.findBlock(MODID, i + "_rail_bridge");
                event.m_246326_((ItemLike)log_bridge_middle);
                event.m_246326_((ItemLike)rope_bridge);
                event.m_246326_((ItemLike)bridge_pier);
                event.m_246326_((ItemLike)log_bridge_stair);
                event.m_246326_((ItemLike)rope_bridge_stair);
                event.m_246326_((ItemLike)rail_bridge);
            }
        }
    }

    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid)) {
            for (String i : STONE) {
                Block stone_bridge = Finder.findBlock(MODID, i + "_bridge");
                Block stone_bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block stone_bridge_stair = Finder.findBlock(MODID, i + "_bridge_stair");
                Block balustrade_stone_bridge = Finder.findBlock(MODID, "balustrade_" + i + "_bridge");
                event.m_246326_((ItemLike)stone_bridge);
                event.m_246326_((ItemLike)stone_bridge_pier);
                event.m_246326_((ItemLike)stone_bridge_stair);
                event.m_246326_((ItemLike)balustrade_stone_bridge);
            }
        }
    }
}

