/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    public static DeferredRegister<Block> blocks(String MODID) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
    }

    public static DeferredRegister<Item> items(String MODID) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
    }

    public static DeferredRegister<CreativeModeTab> creativeModeTab(String MODID) {
        return DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
    }

    public static RegistryObject<CreativeModeTab> tabs(DeferredRegister<CreativeModeTab> event, String MODID, String id, ItemLike icon) {
        RegistryObject tab = event.register(id, () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack(icon)).m_257941_((Component)Component.m_237115_((String)(MODID + "." + id))).m_257652_());
        return tab;
    }

    public static void init(DeferredRegister<Block> b, DeferredRegister<Item> i, DeferredRegister<CreativeModeTab> t) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        b.register(bus);
        i.register(bus);
        t.register(bus);
    }

    public static Block getBlocksFieldForFences(String path, BlockBehaviour.Properties WOOD) {
        FenceBlock block;
        try {
            Class<?> classBase = Class.forName(path);
            Constructor<?> constructorBase = classBase.getConstructor(BlockBehaviour.Properties.class);
            block = (Block)constructorBase.newInstance(WOOD);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            block = new FenceBlock(WOOD);
        }
        return block;
    }

    public static Block getBlocksField(String path, BlockBehaviour.Properties WOOD) {
        Block block;
        try {
            Class<?> classBase = Class.forName(path);
            Constructor<?> constuctorBase = classBase.getConstructor(BlockBehaviour.Properties.class);
            block = (Block)constuctorBase.newInstance(WOOD);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            block = new Block(WOOD);
        }
        return block;
    }

    public static Block getBlocksFieldDoors(String path, BlockBehaviour.Properties WOOD, BlockSetType set) {
        Block block;
        try {
            Class<?> classBase = Class.forName(path);
            Constructor<?> constuctorBase = classBase.getConstructor(BlockBehaviour.Properties.class, BlockSetType.class);
            block = (Block)constuctorBase.newInstance(WOOD, set);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            block = new Block(WOOD);
        }
        return block;
    }

    public static Block getBlocksField(String path, BlockBehaviour.Properties WOOD, BlockState state) {
        Block block;
        try {
            Class<?> classBase = Class.forName(path);
            Constructor<?> constuctorBase = classBase.getConstructor(BlockState.class, BlockBehaviour.Properties.class);
            block = (Block)constuctorBase.newInstance(state, WOOD);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            block = new Block(WOOD);
        }
        return block;
    }
}

