/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettermodsbutton.client.handler;

import fuzs.bettermodsbutton.config.ClientConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.client.gui.TitleScreenModUpdateIndicator;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class ModsButtonHandler {
    @Nullable
    private static TitleScreenModUpdateIndicator pauseScreenUpdateIndicator;

    public static void onScreen$Init$Post(ScreenEvent.Init.Post evt) {
        Screen screen = evt.getScreen();
        if (screen.getClass() == TitleScreen.class) {
            ModsButtonHandler.handleMainMenu(screen.getMinecraft(), screen, evt.getListenersList(), button -> {
                evt.addListener((GuiEventListener)button);
                TitleScreenModUpdateIndicator indicator = ModsButtonHandler.createModUpdateIndicator(screen, button);
                if (indicator != null) {
                    ObfuscationReflectionHelper.setPrivateValue(TitleScreen.class, (Object)((TitleScreen)screen), (Object)indicator, (String)"modUpdateNotification");
                }
            }, arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0));
        } else if (screen.getClass() == PauseScreen.class && ((Boolean)ObfuscationReflectionHelper.getPrivateValue(PauseScreen.class, (Object)((PauseScreen)screen), (String)"f_96306_")).booleanValue()) {
            ModsButtonHandler.handlePauseScreen(screen.getMinecraft(), screen, evt.getListenersList(), button -> {
                evt.addListener((GuiEventListener)button);
                pauseScreenUpdateIndicator = ModsButtonHandler.createModUpdateIndicator(screen, button);
            }, arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0));
        }
    }

    @Nullable
    private static TitleScreenModUpdateIndicator createModUpdateIndicator(Screen screen, Button button) {
        if (((Boolean)ClientConfig.INSTANCE.updateNotification.get()).booleanValue()) {
            TitleScreenModUpdateIndicator indicator = new TitleScreenModUpdateIndicator(button);
            indicator.m_6574_(screen.getMinecraft(), screen.f_96543_, screen.f_96544_);
            indicator.m_7856_();
            return indicator;
        }
        return null;
    }

    public static void onScreen$Render(ScreenEvent.Render evt) {
        if (evt.getScreen().getClass() == PauseScreen.class && pauseScreenUpdateIndicator != null) {
            pauseScreenUpdateIndicator.m_88315_(evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick());
        }
    }

    public static void onScreen$Closing(ScreenEvent.Closing evt) {
        if (evt.getScreen().getClass() == PauseScreen.class) {
            pauseScreenUpdateIndicator = null;
        }
    }

    private static void handleMainMenu(Minecraft minecraft, Screen screen, List<GuiEventListener> children, Consumer<Button> addListener, Consumer<GuiEventListener> removeListener) {
        if (ClientConfig.INSTANCE.mainMenuMode.get() == ClientConfig.MainMenuMode.NO_CHANGE) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(TitleScreen.class, (Object)((TitleScreen)screen), (Object)new TitleScreenModUpdateIndicator(null), (String)"modUpdateNotification");
        switch ((ClientConfig.MainMenuMode)((Object)ClientConfig.INSTANCE.mainMenuMode.get())) {
            case INSERT_BELOW_REALMS: {
                Button modsButton = ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "fml.menu.mods", 200);
                if (modsButton == null) break;
                addListener.accept(modsButton);
                ModsButtonHandler.moveButtonsUpAndDown(screen, children, modsButton.m_252907_() + modsButton.m_93694_());
                modsButton.m_253211_(modsButton.m_252907_() + 24);
                ModsButtonHandler.findButton(children, "menu.online").ifPresent(button -> {
                    button.m_93674_(200);
                    button.m_252865_(button.m_252754_() - 102);
                });
                Screen realmsNotifications = (Screen)ObfuscationReflectionHelper.getPrivateValue(TitleScreen.class, (Object)((TitleScreen)screen), (String)"f_96726_");
                if (realmsNotifications == null) break;
                realmsNotifications.f_96544_ -= 48;
                break;
            }
            case NONE: {
                ModsButtonHandler.findButton(children, "fml.menu.mods").ifPresent(removeListener);
                ModsButtonHandler.findButton(children, "menu.online").ifPresent(button -> {
                    button.m_93674_(200);
                    button.m_252865_(button.m_252754_() - 102);
                });
                break;
            }
            case LEFT_TO_REALMS: {
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "fml.menu.mods"));
                break;
            }
            case RIGHT_TO_REALMS: {
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, (GuiEventListener $) -> {}, "menu.online"));
                ModsButtonHandler.findButton(children, "menu.online").ifPresent(button -> {
                    ModsButtonHandler.tryReplaceButton(children, removeListener, "fml.menu.mods", button, -1);
                    Screen realmsNotifications = (Screen)ObfuscationReflectionHelper.getPrivateValue(TitleScreen.class, (Object)((TitleScreen)screen), (String)"f_96726_");
                    if (realmsNotifications != null) {
                        realmsNotifications.f_96543_ -= 204;
                    }
                });
                break;
            }
            case REPLACE_REALMS: {
                ModsButtonHandler.findButton(children, "menu.online").ifPresent(removeListener);
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "fml.menu.mods", 200));
            }
        }
    }

    private static void handlePauseScreen(Minecraft minecraft, Screen screen, List<GuiEventListener> children, Consumer<Button> addListener, Consumer<GuiEventListener> removeListener) {
        if (ClientConfig.INSTANCE.pauseScreenMode.get() == ClientConfig.PauseScreenMode.NO_CHANGE) {
            return;
        }
        ModsButtonHandler.findButton(children, "fml.menu.mods").ifPresent(button -> {
            ModsButtonHandler.moveButtonsUpAndDown(screen, children, -12, button.m_252907_());
            removeListener.accept((GuiEventListener)button);
        });
        switch ((ClientConfig.PauseScreenMode)((Object)ClientConfig.INSTANCE.pauseScreenMode.get())) {
            case INSERT_BELOW_FEEDBACK_AND_BUGS: {
                Button modsButton = ModsButtonHandler.tryReplaceButton(minecraft, screen, children, $ -> {}, "menu.options", 204);
                if (modsButton == null) break;
                addListener.accept(modsButton);
                ModsButtonHandler.moveButtonsUpAndDown(screen, children, modsButton.m_252907_());
                modsButton.m_253211_(modsButton.m_252907_() - 24);
                break;
            }
            case REPLACE_FEEDBACK: {
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "menu.sendFeedback"));
                break;
            }
            case REPLACE_BUGS: {
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "menu.reportBugs"));
                break;
            }
            case REPLACE_FEEDBACK_AND_BUGS: {
                ModsButtonHandler.findButton(children, "menu.reportBugs").ifPresent(removeListener);
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, "menu.sendFeedback", 204));
                break;
            }
            case REPLACE_AND_MOVE_LAN: {
                ModsButtonHandler.findButton(children, "menu.sendFeedback").ifPresent(removeListener);
                ModsButtonHandler.findButton(children, "menu.reportBugs").ifPresent(removeListener);
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, (GuiEventListener $) -> {}, "menu.shareToLan"));
                ModsButtonHandler.findButton(children, "menu.shareToLan").ifPresent(button -> {
                    button.m_93674_(204);
                    button.m_252865_(button.m_252754_() - 106);
                    button.m_253211_(button.m_252907_() - 24);
                });
                break;
            }
            case INSERT_AND_MOVE_LAN: {
                addListener.accept(ModsButtonHandler.tryReplaceButton(minecraft, screen, children, (GuiEventListener $) -> {}, "menu.shareToLan"));
                ModsButtonHandler.findButton(children, "menu.shareToLan").ifPresent(button -> {
                    ModsButtonHandler.moveButtonsUpAndDown(screen, children, button.m_252907_());
                    button.m_93674_(204);
                    button.m_252865_(button.m_252754_() - 106);
                    button.m_253211_(button.m_252907_() - 24);
                });
            }
        }
    }

    private static void moveButtonsUpAndDown(Screen screen, List<GuiEventListener> listeners, int splitAt) {
        ModsButtonHandler.moveButtonsUpAndDown(screen, listeners, 12, splitAt);
    }

    private static void moveButtonsUpAndDown(Screen screen, List<GuiEventListener> listeners, int moveAmount, int splitAt) {
        for (GuiEventListener widget : listeners) {
            LayoutElement element;
            if (!(widget instanceof LayoutElement) || ModsButtonHandler.isElementTooCloseToScreenBorder(element = (LayoutElement)widget, screen.f_96543_, screen.f_96544_)) continue;
            if (splitAt <= element.m_252907_()) {
                element.m_253211_(element.m_252907_() + moveAmount);
                continue;
            }
            element.m_253211_(element.m_252907_() - moveAmount);
        }
    }

    private static boolean isElementTooCloseToScreenBorder(LayoutElement element, int screenWidth, int screenHeight) {
        int safeArea;
        ScreenRectangle rectangle = element.m_264198_();
        ScreenRectangle intersection = rectangle.m_275842_(new ScreenRectangle(safeArea = ((Integer)ClientConfig.INSTANCE.safeArea.get()).intValue(), safeArea, Math.max(0, screenWidth -= 2 * safeArea), Math.max(0, screenHeight -= 2 * safeArea)));
        return intersection == null || !intersection.equals((Object)rectangle);
    }

    @Nullable
    private static Button tryReplaceButton(Minecraft minecraft, Screen screen, List<GuiEventListener> children, Consumer<GuiEventListener> removeListener, String s) {
        return ModsButtonHandler.tryReplaceButton(minecraft, screen, children, removeListener, s, -1);
    }

    @Nullable
    private static Button tryReplaceButton(Minecraft minecraft, Screen screen, List<GuiEventListener> children, Consumer<GuiEventListener> removeListener, String s, int newWidth) {
        Button newButton = ModsButtonHandler.tryReplaceButton(children, removeListener, s, Button.m_253074_((Component)CommonComponents.f_237098_, $ -> minecraft.m_91152_((Screen)new ModListScreen(screen))).m_253136_(), newWidth);
        if (newButton != null) {
            Component title = ModsButtonHandler.buildModsComponent((Boolean)ClientConfig.INSTANCE.addModCount.get(), newButton.m_5711_() < 200);
            newButton.m_93666_(title);
        }
        return newButton;
    }

    @Nullable
    private static Button tryReplaceButton(List<GuiEventListener> children, Consumer<GuiEventListener> removeListener, String s, Button newButton, int newWidth) {
        return ModsButtonHandler.findButton(children, s).map(button -> {
            removeListener.accept((GuiEventListener)button);
            newButton.m_264152_(button.m_252754_(), button.m_252907_());
            newButton.m_93674_(newWidth != -1 ? newWidth : button.m_5711_());
            newButton.setHeight(button.m_93694_());
            return newButton;
        }).orElse(null);
    }

    private static Optional<Button> findButton(List<GuiEventListener> widgets, String s) {
        for (GuiEventListener widget : widgets) {
            Button button;
            if (!(widget instanceof Button) || !ModsButtonHandler.matchesTranslationKey(button = (Button)widget, s)) continue;
            return Optional.of(button);
        }
        return Optional.empty();
    }

    private static boolean matchesTranslationKey(Button button, String key) {
        TranslatableContents contents;
        ComponentContents message = button.m_6035_().m_214077_();
        return message instanceof TranslatableContents && (contents = (TranslatableContents)message).m_237508_().equals(key);
    }

    private static Component buildModsComponent(boolean withCount, boolean compact) {
        MutableComponent component = Component.m_237115_((String)"fml.menu.mods");
        if (withCount) {
            String translationKey = compact ? "button.mods.count.compact" : "button.mods.count";
            component = component.m_130946_(" ").m_7220_((Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{ModList.get().size()}));
        }
        return component;
    }
}

