/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.gui.NetworkCraftingInventory;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClearRecipeMessage {
    public static void handle(ClearRecipeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ClearRecipeMessage.clearContainerRecipe(player, true);
        });
        ctx.get().setPacketHandled(true);
    }

    public static ClearRecipeMessage decode(FriendlyByteBuf buf) {
        return new ClearRecipeMessage();
    }

    public static void encode(ClearRecipeMessage msg, FriendlyByteBuf buf) {
    }

    static void clearContainerRecipe(ServerPlayer player, boolean doRefresh) {
        if (player.f_36096_ instanceof ContainerNetwork) {
            ContainerNetwork container = (ContainerNetwork)player.f_36096_;
            NetworkCraftingInventory craftMatrix = container.getCraftMatrix();
            if (container.isCrafting() && craftMatrix != null) {
                TileMain root = container.getTileMain();
                for (int i = 0; i < 9 && root != null; ++i) {
                    int remainingAfter;
                    int numBeforeInsert;
                    ItemStack stackInSlot = craftMatrix.m_8020_(i);
                    if (stackInSlot.m_41619_() || (numBeforeInsert = stackInSlot.m_41613_()) == (remainingAfter = root.insertStack(stackInSlot.m_41777_(), false))) continue;
                    if (remainingAfter == 0) {
                        craftMatrix.m_6836_(i, ItemStack.f_41583_);
                        continue;
                    }
                    craftMatrix.m_6836_(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfter));
                }
                if (doRefresh) {
                    List<ItemStack> list = root.getNetwork().getStacks();
                    PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    container.m_38946_();
                }
            }
        }
    }
}

