/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.api.OpCompareType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.capability.handler.UpgradesItemStackHandler;
import com.lothrazar.storagenetwork.item.ItemUpgrade;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.Request;
import com.lothrazar.storagenetwork.util.RequestBatch;
import com.lothrazar.storagenetwork.util.UtilInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableAutoIO
implements INBTSerializable<CompoundTag>,
IConnectableItemAutoIO {
    public static final int DEFAULT_ITEMS_PER = 4;
    public static final int IO_DEFAULT_SPEED = 30;
    public final IConnectable connectable;
    public EnumStorageDirection direction;
    public final UpgradesItemStackHandler upgrades = new UpgradesItemStackHandler();
    private final FilterItemStackHandler filters = new FilterItemStackHandler();
    private int priority = 0;
    private Direction inventoryFace;
    private boolean needsRedstone = false;
    public ItemStack operationStack = ItemStack.f_41583_;
    public int operationLimit = 0;
    public int operationType = OpCompareType.LESS.ordinal();

    CapabilityConnectableAutoIO(EnumStorageDirection direction) {
        this.connectable = new CapabilityConnectable();
        this.direction = direction;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.needsRedstone = !this.needsRedstone;
    }

    @Override
    public boolean needsRedstone() {
        return this.needsRedstone;
    }

    @Override
    public void needsRedstone(boolean in) {
        this.needsRedstone = in;
    }

    public FilterItemStackHandler getFilter() {
        return this.filters;
    }

    public List<ItemStack> getStoredStacks(boolean isFiltered) {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || isFiltered && this.filters.isStackFiltered(stack)) continue;
            result.add(stack.m_41777_());
        }
        return result;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public void setFilter(int value, ItemStack stack) {
        this.filters.setStackInSlot(value, stack);
        this.filters.getStacks().set(value, stack);
    }

    public CapabilityConnectableAutoIO(BlockEntity tile, EnumStorageDirection direction) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
        this.direction = direction;
        if (direction == EnumStorageDirection.OUT) {
            this.filters.setIsAllowlist(true);
        } else {
            this.filters.setIsAllowlist(false);
        }
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128365_("upgrades", (Tag)this.upgrades.serializeNBT());
        result.m_128365_("filters", (Tag)this.filters.serializeNBT());
        result.m_128405_("prio", this.priority);
        if (this.inventoryFace != null) {
            result.m_128359_("inventoryFace", this.inventoryFace.toString());
        }
        result.m_128379_("needsRedstone", this.needsRedstone());
        CompoundTag operation = new CompoundTag();
        operation.m_128365_("stack", (Tag)this.operationStack.serializeNBT());
        operation.m_128405_("operationType", this.operationType);
        operation.m_128405_("limit", this.operationLimit);
        result.m_128365_("operation", (Tag)operation);
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag filters;
        CompoundTag upgrades = nbt.m_128469_("upgrades");
        if (upgrades != null) {
            this.upgrades.deserializeNBT(upgrades);
        }
        if ((filters = nbt.m_128469_("filters")) != null) {
            this.filters.deserializeNBT(filters);
        }
        this.priority = nbt.m_128451_("prio");
        if (nbt.m_128441_("inventoryFace")) {
            this.inventoryFace = Direction.m_122402_((String)nbt.m_128461_("inventoryFace"));
        }
        this.needsRedstone(nbt.m_128471_("needsRedstone"));
        CompoundTag operation = nbt.m_128469_("operation");
        this.operationLimit = operation.m_128451_("limit");
        this.operationType = operation.m_128451_("operationType");
        this.operationStack = operation.m_128441_("stack") ? ItemStack.m_41712_((CompoundTag)operation.m_128469_("stack")) : ItemStack.f_41583_;
    }

    @Override
    public EnumStorageDirection ioDirection() {
        return this.direction;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.direction == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    public List<ItemStack> getStacksForFilter() {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || this.filters.exactStackAlreadyInList(stack)) continue;
            result.add(stack.m_41777_());
            if (result.size() < 18) continue;
            return result;
        }
        return result;
    }

    @Override
    public FilterItemStackHandler getFilters() {
        return this.filters;
    }

    @Override
    public IItemHandler getItemHandler() {
        if (this.inventoryFace == null || this.direction == EnumStorageDirection.OUT) {
            return null;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        return (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
    }

    @Override
    public boolean isStockMode() {
        return this.getUpgrades().hasUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.STOCK_UPGRADE.get()));
    }

    @Override
    public boolean isOperationMode() {
        return this.getUpgrades().hasUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.OP_U.get()));
    }

    @Override
    public int getTransferRate() {
        if (this.upgrades.hasUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.SINGLE_UPGRADE.get()))) {
            return 1;
        }
        return this.upgrades.hasUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.STACK_UPGRADE.get())) ? 64 : 4;
    }

    private boolean doesPassOperationFilterLimit(TileMain master) {
        if (this.upgrades.getUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.OP_U.get())) < 1) {
            return true;
        }
        if (this.operationStack == null || this.operationStack.m_41619_()) {
            return true;
        }
        int countYourItemInNetwork = master.getNetwork().getAmount(new ItemStackMatcher(this.operationStack, this.filters.tags, this.filters.nbt));
        switch (OpCompareType.get(this.operationType)) {
            case EQUAL: {
                return countYourItemInNetwork == this.operationLimit;
            }
            case GREATER: {
                return countYourItemInNetwork > this.operationLimit;
            }
            case LESS: {
                return countYourItemInNetwork < this.operationLimit;
            }
        }
        return false;
    }

    @Override
    public boolean canRunNow(DimPos connectablePos, TileMain main) {
        boolean cooldownOk;
        int speedUpgrades = this.upgrades.getUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.SPEED_UPGRADE.get()));
        int slowUpgrades = this.upgrades.getUpgradesOfType((ItemUpgrade)((Object)SsnRegistry.Items.SLOW_UPGRADE.get()));
        int speedRatio = 30;
        if (speedUpgrades > 0) {
            speedRatio = 30 / (speedUpgrades + 1);
        } else if (slowUpgrades > 0) {
            speedRatio = 30 * (slowUpgrades + 1);
        }
        if (speedRatio < 1) {
            speedRatio = 1;
        }
        boolean bl = cooldownOk = connectablePos.getWorld().m_46467_() % (long)speedRatio == 0L;
        if (!cooldownOk) {
            return false;
        }
        boolean operationLimitOk = this.doesPassOperationFilterLimit(main);
        return operationLimitOk;
    }

    @Override
    public List<IItemStackMatcher> getAutoExportList() {
        return this.filters.getStackMatchers();
    }

    @Override
    public Direction facingInventory() {
        return this.inventoryFace;
    }

    public UpgradesItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public void extractFromSlot(int slot) {
    }

    @Override
    public RequestBatch runExport(TileMain main) {
        if (this.ioDirection() != EnumStorageDirection.OUT) {
            return null;
        }
        RequestBatch requestBatch = new RequestBatch();
        for (IItemStackMatcher matcher : this.getAutoExportList()) {
            if (matcher.getStack().m_41619_()) continue;
            Request request = new Request(this);
            boolean stockMode = this.isStockMode();
            if (stockMode) {
                StorageNetworkMod.log("stockMode == TRUE ; updateExports: attempt " + matcher.getStack());
                try {
                    DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
                    IItemHandler targetInventory = (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
                    int stillNeeds = UtilInventory.containsAtLeastHowManyNeeded(targetInventory, matcher.getStack(), matcher.getStack().m_41613_());
                    if (stillNeeds == 0) {
                        StorageNetworkMod.log("stockMode upgrade finishing transaction");
                        continue;
                    }
                    request.setCount(Math.min(stillNeeds, request.getCount()));
                    StorageNetworkMod.log("updateExports stock mode edited value: amtToRequest = " + request.getCount());
                }
                catch (Throwable e) {
                    StorageNetworkMod.LOGGER.error("Error thrown from a connected block" + e);
                }
            }
            if (matcher.getStack().m_41619_() || request.getCount() == 0) continue;
            requestBatch.put(matcher.getStack().m_41720_(), request);
        }
        return requestBatch;
    }

    @Override
    public void runImport(TileMain main) {
        if (this.ioDirection() != EnumStorageDirection.IN) {
            return;
        }
        IItemHandler itemHandler = this.getItemHandler();
        if (itemHandler == null) {
            return;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            int extractSize;
            ItemStack stackToImport;
            if (itemHandler.getStackInSlot(slot).m_41619_()) continue;
            ItemStack stackCurrent = itemHandler.getStackInSlot(slot).m_41777_();
            if (this.getFilters() != null && this.getFilters().isStackFiltered(stackCurrent)) continue;
            if (this.isStockMode()) {
                int filterSize = this.getFilters().getStackCount(stackCurrent);
                DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
                IItemHandler targetInventory = (IItemHandler)inventoryPos.getCapability(ForgeCapabilities.ITEM_HANDLER, this.inventoryFace.m_122424_());
                int chestHowMany = UtilInventory.countHowMany(targetInventory, stackCurrent);
                if (chestHowMany > filterSize) {
                    int realSize = Math.min(chestHowMany - filterSize, 64);
                    StorageNetworkMod.log(" : stock mode import  realSize = " + realSize);
                    stackCurrent.m_41764_(realSize);
                } else {
                    StorageNetworkMod.log(" : stock mode CANCEL: ITS NOT ENOUGH chestHowMany <= filter size ");
                    continue;
                }
            }
            if ((stackToImport = itemHandler.extractItem(slot, extractSize = Math.min(this.getTransferRate(), stackCurrent.m_41613_()), true)).m_41619_()) continue;
            int countUnmoved = main.insertStack(stackToImport, true);
            int countMoved = stackToImport.m_41613_() - countUnmoved;
            if (countMoved <= 0) continue;
            ItemStack actuallyExtracted = itemHandler.extractItem(slot, countMoved, false);
            main.insertStack(actuallyExtracted, false);
            break;
        }
    }

    public static class Factory
    implements Callable<IConnectableItemAutoIO> {
        @Override
        public IConnectableItemAutoIO call() throws Exception {
            return new CapabilityConnectableAutoIO(EnumStorageDirection.IN);
        }
    }
}

