/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.processing;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class ProcessRequestModel {
    private static final String PREFIX = "sn_process_";
    private int count;
    private boolean alwaysActive = false;
    private ProcessStatus status = ProcessStatus.EXPORTING;
    private int stackIndex;
    private Direction inputFace = Direction.UP;
    private Direction outputFace = Direction.DOWN;

    public int getCount() {
        return this.count;
    }

    public void reduceCount() {
        if (this.count > 0) {
            --this.count;
        }
    }

    public void setCount(int countRequested) {
        if (this.count <= 0 && countRequested > 0) {
            this.setStatus(ProcessStatus.EXPORTING);
        }
        this.count = countRequested;
    }

    public void readFromNBT(CompoundTag compound) {
        this.count = compound.m_128451_("sn_process_count");
        this.status = ProcessStatus.values()[compound.m_128451_("sn_process_status")];
        this.alwaysActive = compound.m_128471_("sn_process_always");
        this.stackIndex = compound.m_128451_("sn_process_stack");
        this.inputFace = Direction.values()[compound.m_128451_("sn_process_in")];
        this.outputFace = Direction.values()[compound.m_128451_("sn_process_out")];
    }

    public CompoundTag writeToNBT(CompoundTag compound) {
        compound.m_128405_("sn_process_count", this.count);
        compound.m_128405_("sn_process_status", this.status.ordinal());
        compound.m_128379_("sn_process_always", this.alwaysActive);
        compound.m_128405_("sn_process_stack", this.stackIndex);
        compound.m_128405_("sn_process_in", this.inputFace.ordinal());
        compound.m_128405_("sn_process_out", this.outputFace.ordinal());
        return compound;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        if (status == this.status) {
            return;
        }
        this.status = status;
        this.stackIndex = 0;
    }

    public boolean isAlwaysActive() {
        return this.alwaysActive;
    }

    public void setAlwaysActive(boolean alwaysActive) {
        this.alwaysActive = alwaysActive;
    }

    public int getStackIndex() {
        return this.stackIndex;
    }

    public void increaseStackIndex() {
        ++this.stackIndex;
    }

    public Direction getInputFace() {
        return this.inputFace;
    }

    public void setInputFace(Direction inputFace) {
        this.inputFace = inputFace;
    }

    public Direction getOutputFace() {
        return this.outputFace;
    }

    public void setOutputFace(Direction outputFace) {
        this.outputFace = outputFace;
    }

    public static enum ProcessStatus {
        HALTED,
        IMPORTING,
        EXPORTING;

    }
}

