/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.processor;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.joefoxe.hexerei.Hexerei;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@MethodsReturnNonnullByDefault
public class MangroveTreeLegProcessor
extends StructureProcessor {
    public static final MangroveTreeLegProcessor INSTANCE = new MangroveTreeLegProcessor();
    public static final Codec<MangroveTreeLegProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public static boolean isAirOrLeavesOrLogsAt(ChunkAccess currentChunk, BlockPos pos) {
        BlockState state = currentChunk.m_8055_(pos);
        return state.m_247087_() || state.m_60795_() || state.m_60713_(Blocks.f_50571_) || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_);
    }

    @ParametersAreNonnullByDefault
    public StructureTemplate.StructureBlockInfo process(LevelReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, @Nullable StructureTemplate template) {
        WorldGenRegion worldGenRegion;
        ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.f_74675_());
        ChunkAccess currentChunk = worldReader.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
        RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)blockInfoGlobal.f_74675_());
        if (worldReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)worldReader).m_143488_().equals((Object)new ChunkPos((BlockPos)currentPos))) {
            return MangroveTreeLegProcessor.getReturnBlock(blockInfoGlobal.f_74675_(), blockInfoGlobal.f_74676_());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return Hexerei.MANGROVE_TREE_LEG_PROCESSOR;
    }

    private static StructureTemplate.StructureBlockInfo getReturnBlock(BlockPos worldPos, BlockState originalReplacementState) {
        return originalReplacementState == null || originalReplacementState.m_60713_(Blocks.f_50454_) ? null : new StructureTemplate.StructureBlockInfo(worldPos, originalReplacementState, null);
    }
}

