/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.UUID;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.OwlCourierDepot;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotSavedData;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SendOwlCourierPacket {
    int sourceId;
    boolean deliverToEntity;
    GlobalPos pos;
    InteractionHand hand;
    UUID entityId;

    public SendOwlCourierPacket(Entity owl, GlobalPos pos, InteractionHand hand) {
        this.sourceId = owl.m_19879_();
        this.pos = pos;
        this.hand = hand;
        this.deliverToEntity = false;
    }

    public SendOwlCourierPacket(Entity owl, UUID playerUUID, InteractionHand hand) {
        this.sourceId = owl.m_19879_();
        this.entityId = playerUUID;
        this.hand = hand;
        this.deliverToEntity = true;
    }

    public SendOwlCourierPacket(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.deliverToEntity = buf.readBoolean();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        if (this.deliverToEntity) {
            this.entityId = buf.m_130259_();
        } else {
            this.pos = buf.m_236872_();
        }
    }

    public static void encode(SendOwlCourierPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeBoolean(object.deliverToEntity);
        buffer.m_130068_((Enum)object.hand);
        if (object.deliverToEntity) {
            buffer.m_130077_(object.entityId);
        } else {
            buffer.m_236814_(object.pos);
        }
    }

    public static SendOwlCourierPacket decode(FriendlyByteBuf buffer) {
        return new SendOwlCourierPacket(buffer);
    }

    public static void consume(SendOwlCourierPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity patt3263$temp = world.m_6815_(packet.sourceId);
            if (patt3263$temp instanceof OwlEntity) {
                OwlEntity owl = (OwlEntity)patt3263$temp;
                if (owl.currentTask.isNone() && player != null) {
                    if (packet.deliverToEntity) {
                        ItemStack copyStack;
                        if (ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(packet.entityId) != null && ((copyStack = player.m_21120_(packet.hand).m_41777_()).m_41720_() == ModItems.COURIER_PACKAGE.get() || copyStack.m_41720_() == ModItems.COURIER_LETTER.get())) {
                            ServerPlayer player1 = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(packet.entityId);
                            owl.messagingController.setDestination((Player)player1);
                            copyStack.m_41764_(1);
                            owl.messagingController.setMessageStack(copyStack);
                            player.m_21120_(packet.hand).m_41774_(1);
                            owl.sync();
                        }
                    } else {
                        ServerLevel level = world.m_7654_().m_129880_(packet.pos.m_122640_());
                        if (level != null && level.m_8055_(packet.pos.m_122646_()).m_60734_() instanceof OwlCourierDepot) {
                            ItemStack copyStack = player.m_21120_(packet.hand).m_41777_();
                            if (copyStack.m_41720_() == ModItems.COURIER_PACKAGE.get() || copyStack.m_41720_() == ModItems.COURIER_LETTER.get()) {
                                owl.messagingController.setDestination(packet.pos);
                                copyStack.m_41764_(1);
                                owl.messagingController.setMessageStack(copyStack);
                                player.m_21120_(packet.hand).m_41774_(1);
                                owl.sync();
                            }
                        } else {
                            OwlCourierDepotSavedData.get().clearOwlCourierDepot(packet.pos);
                            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                            return;
                        }
                    }
                    owl.messagingController.start(GlobalPos.m_122643_((ResourceKey)owl.m_9236_().m_46472_(), (BlockPos)owl.m_20183_()));
                    owl.currentTask = OwlEntity.OwlTask.DELIVER_MESSAGE;
                } else if (player != null) {
                    player.m_213846_((Component)Component.m_237110_((String)"message.hexerei.owl_already_doing_task", (Object[])new Object[]{owl.m_7755_()}));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

