/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.block.custom.BroomStandWall;
import net.joefoxe.hexerei.tileentity.BroomStandTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;

public class BroomStandRenderer
implements BlockEntityRenderer<BroomStandTile> {
    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BroomStandTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Block block;
        Level level = tileEntityIn.m_58904_();
        if (level == null) {
            return;
        }
        if (!level.m_8055_(tileEntityIn.m_58899_()).m_155947_() || !(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof BroomStandTile)) {
            return;
        }
        Vec3 offset = new Vec3(0.0, 0.0, 0.0);
        ItemStack stack = tileEntityIn.itemHandler.getStackInSlot(0);
        Direction dir = Direction.NORTH;
        if (tileEntityIn.m_58900_().m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && ((dir = (Direction)tileEntityIn.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) == Direction.NORTH || dir == Direction.SOUTH)) {
            dir = dir.m_122424_();
        }
        if ((block = tileEntityIn.m_58900_().m_60734_()) instanceof BroomStandWall) {
            BroomStandWall broomStandWall = (BroomStandWall)block;
            offset = new Vec3(0.0, -0.421875, (double)-0.15f);
        }
        if (!stack.m_41619_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 0.640625f, 0.5f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(dir.m_122435_()));
            matrixStackIn.m_85837_(0.0, offset.m_7098_(), 0.015625 + offset.m_7094_());
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-16.0f));
            matrixStackIn.m_85841_(2.25f, 2.25f, 2.25f);
            this.renderItem(stack, tileEntityIn.m_58904_(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int overlayLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, overlayLightIn, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

