/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.CourierPackage;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CourierPackageTile
extends RandomizableContainerBlockEntity
implements Container,
Clearable {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private boolean sealed = false;

    public CourierPackageTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CourierPackageTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.COURIER_PACKAGE_TILE.get(), blockPos, blockState);
    }

    public boolean interact(Player pPlayer) {
        this.m_59640_(pPlayer);
        if (!this.m_7983_() && this.m_58898_()) {
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ItemStack stack : this.itemStacks) {
                    ItemEntity ie = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), stack, serverLevel.f_46441_.m_188500_() * 0.2 - 0.1, 0.3, serverLevel.f_46441_.m_188500_() * 0.2 - 0.1);
                    ie.m_32060_();
                    this.f_58857_.m_7967_((Entity)ie);
                }
                this.m_6211_();
                this.m_6596_();
                serverLevel.m_5594_(null, this.m_58899_(), SoundEvents.f_184214_, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.m_5594_(null, this.m_58899_(), SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 0.2f);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 10, 0.25, 0.25, 0.25, 0.02);
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_58900_()), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 25, 0.25, 0.25, 0.25, 0.02);
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CourierPackage.STATE, (Comparable)((Object)CourierPackage.State.OPENED)));
            }
            return true;
        }
        return false;
    }

    public BlockEntityType<?> m_58903_() {
        return super.m_58903_();
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        super.m_6836_(pIndex, pStack);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.itemStacks;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.itemStacks = itemsIn;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public void m_5856_(Player p_18955_) {
        super.m_5856_(p_18955_);
    }

    public void m_5785_(Player p_18954_) {
        super.m_5785_(p_18954_);
    }

    public boolean m_7013_(int p_18952_, ItemStack stack) {
        String id = HexereiUtil.getRegistryName(stack.m_41720_()).toString();
        if (((List)HexConfig.COFFER_BLACKLIST.get()).contains(id)) {
            return false;
        }
        return super.m_7013_(p_18952_, stack);
    }

    public int m_18947_(Item p_18948_) {
        return super.m_18947_(p_18948_);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.coffer");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CofferContainer(id, this.f_58857_, this.f_58858_, player, player.f_35978_);
    }

    public void m_6211_() {
        super.m_6211_();
        this.itemStacks = NonNullList.m_122780_((int)this.itemStacks.size(), (Object)ItemStack.f_41583_);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        return super.getModelData();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public CompoundTag save(CompoundTag pTag) {
        this.m_183515_(pTag);
        return pTag;
    }

    public CompoundTag saveData(CompoundTag pTag) {
        if (!this.m_7983_()) {
            return this.save(pTag);
        }
        return pTag;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadFromTag(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18976_((CompoundTag)pTag, this.itemStacks, (boolean)false);
        }
        pTag.m_128379_("Sealed", this.sealed);
    }

    public void loadFromTag(CompoundTag pTag) {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag) && pTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.itemStacks);
        }
        if (pTag.m_128441_("Sealed")) {
            this.sealed = pTag.m_128471_("Sealed");
        }
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void sync() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public boolean m_7983_() {
        if (this.itemStacks != null) {
            for (int i = 0; i < this.m_7086_().size(); ++i) {
                if (((ItemStack)this.m_7086_().get(i)).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public void tick() {
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public int m_6893_() {
        return super.m_6893_();
    }
}

