/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.SendOwlCourierPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;

public class OwlCourierSendScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("hexerei", "textures/gui/owl_courier_delivery_gui.png");
    public final OwlEntity owl;
    private List<ListButton> listButtons = new ArrayList<ListButton>();
    private ListButton sendButton;
    int ticks = 0;
    float scroll = 0.0f;
    float scrollOld = 0.0f;
    float scrollTarget = 0.0f;
    boolean scrollClicked = false;
    double scrollClickedPos = 0.0;
    int img_width = 124;
    int img_height = 164;
    int left;
    int top;
    int button_height = 16;
    int button_space = 3;
    int button_selected = 0;
    ScissorArea scissorArea;
    InteractionHand hand;

    public OwlCourierSendScreen(OwlEntity owl, InteractionHand hand, int selected) {
        super((Component)Component.m_237115_((String)"hexerei.owl_message.destination"));
        this.f_96541_ = Minecraft.m_91087_();
        this.owl = owl;
        this.hand = hand;
        if (this.f_96541_.f_91074_ != null && selected != this.f_96541_.f_91074_.m_150109_().f_35977_) {
            this.m_7379_();
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.listButtons.size() > 6) {
            this.scrollTarget = (float)((double)this.scrollTarget + (double)(((float)(this.button_height + this.button_space) + (float)(this.button_height + this.button_space) * Mth.m_14154_((float)(this.scrollTarget - this.scroll))) / (float)(this.listButtons.size() * this.button_height - this.scissorArea.height)) * -pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX >= (double)(this.left + 250 - 149) && pMouseX < (double)(this.left + 250 - 149 + 10) && pMouseY >= (double)((float)(this.top + 21) + this.scroll * 101.0f) && pMouseY < (double)((float)(this.top + 21 + 5) + this.scroll * 101.0f)) {
            this.scrollClicked = true;
            this.scrollClickedPos = pMouseY - (double)((float)(this.top + 21) + this.scroll * 101.0f);
            return true;
        }
        if (pMouseX >= (double)(this.left + 250 - 149) && pMouseX < (double)(this.left + 250 - 149 + 8) && pMouseY >= (double)(this.top + 21) && pMouseY < (double)(this.top + 21 + 106)) {
            this.scroll = (float)(pMouseY - (double)(this.top + 23)) / 101.0f;
            this.scrollClicked = true;
            this.scrollClickedPos = pMouseY - (double)((float)(this.top + 21) + this.scroll * 101.0f);
        }
        for (ListButton button : this.listButtons) {
            if (!button.isHovered || !button.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        if (this.sendButton != null && this.sendButton.isHovered && this.sendButton.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollClicked = false;
        for (ListButton button : this.listButtons) {
            if (!button.isHovered || !button.mouseReleased(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        if (this.sendButton != null && this.sendButton.isHovered && this.sendButton.mouseReleased(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7856_() {
        this.left = this.f_96543_ / 2 - this.img_width / 2;
        this.top = this.f_96544_ / 2 - this.img_height / 2;
        this.scissorArea = new ScissorArea(this.left + 163 - 149, this.top + 21, 94, 106);
        this.listButtons.clear();
        int i = 0;
        int listSize = ClientOwlCourierDepotData.getDepots().size();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ClientPacketListener handler = this.f_96541_.f_91074_.f_108617_;
            listSize += handler.m_105142_().size();
            for (PlayerInfo playerInfo : handler.m_105142_()) {
                int compare = this.f_96541_.f_91074_.m_20148_().compareTo(playerInfo.m_105312_().getId());
                if (compare == 0) continue;
                this.listButtons.add(new ListButton(this.left + 163 - 149, this.top + 21 + (this.button_height + this.button_space) * i, listSize < 7 ? 94 : 88, this.button_height, button -> {
                    for (ListButton lb : this.listButtons) {
                        lb.isSelected = false;
                    }
                    button.isSelected = true;
                    this.button_selected = button.index;
                }, button -> {
                    this.onDone();
                    HexereiPacketHandler.sendToServer(new SendOwlCourierPacket((Entity)this.owl, playerInfo.m_105312_().getId(), this.hand));
                }, this.scissorArea, playerInfo.m_105312_().getName(), true, false, i));
                ++i;
            }
        }
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : ClientOwlCourierDepotData.getDepots().entrySet()) {
            this.listButtons.add(new ListButton(this.left + 164 - 149, this.top + 21 + (this.button_height + this.button_space) * i, listSize < 7 ? 94 : 88, this.button_height, button -> {
                for (ListButton lb : this.listButtons) {
                    lb.isSelected = false;
                }
                button.isSelected = true;
                this.button_selected = button.index;
            }, button -> {
                this.onDone();
                HexereiPacketHandler.sendToServer(new SendOwlCourierPacket((Entity)this.owl, (GlobalPos)entry.getKey(), this.hand));
            }, this.scissorArea, entry.getValue().name, false, entry.getValue().isFull(), i));
            ++i;
        }
        if (this.listButtons.isEmpty()) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"screen.hexerei.owl_send_screen.no_destinations"));
            this.onDone();
        }
        this.sendButton = new ListButton(this.left + 186 - 149, this.top + 133, 50, this.button_height, button -> this.listButtons.get((int)this.button_selected).onComplete.onPress(this.listButtons.get(this.button_selected)), button -> {}, new ScissorArea(this.left + 186 - 149, this.top + 133, 50, this.button_height), "Send", false, false, i){

            @Override
            public int getY(float partialTicks) {
                return this.y;
            }

            @Override
            public void tooltip(List<Component> list) {
                if (this.isHovered() && !this.isDisabled()) {
                    list.add((Component)Component.m_237110_((String)"screen.hexerei.owl_send_screen.send_to", (Object[])new Object[]{OwlCourierSendScreen.this.listButtons.get((int)OwlCourierSendScreen.this.button_selected).name}).m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
                }
            }

            @Override
            public boolean isDisabled() {
                return OwlCourierSendScreen.this.listButtons.get((int)OwlCourierSendScreen.this.button_selected).isDisabled;
            }
        };
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.listButtons.size() > 6) {
            if (this.scrollClicked) {
                this.scrollTarget = this.scroll = Mth.m_14036_((float)((float)((double)(pMouseY - this.top - 21) - this.scrollClickedPos) / 101.0f), (float)0.0f, (float)1.0f);
                this.scrollOld = this.scroll;
            }
        } else {
            this.scroll = 0.0f;
        }
        float scrollLerp = Mth.m_14179_((float)pPartialTick, (float)this.scrollOld, (float)this.scroll);
        Lighting.m_84930_();
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.top + 4, 0x333333);
        for (ListButton button : this.listButtons) {
            button.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        if (this.sendButton != null) {
            this.sendButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        pGuiGraphics.m_280218_(this.GUI, this.left, this.top, 0, 0, this.img_width, this.img_height);
        if (this.listButtons.size() > 6) {
            pGuiGraphics.m_280218_(this.GUI, this.left + 252 - 149, this.top + 21, 127, 177, 6, 53);
            pGuiGraphics.m_280218_(this.GUI, this.left + 252 - 149, this.top + 21 + 53, 134, 177, 6, 53);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 5.0f);
            pGuiGraphics.m_280218_(this.GUI, this.left + 250 - 149, this.top + 21 + (int)(101.0f * scrollLerp), 127, 171, 10, 5);
            pGuiGraphics.m_280168_().m_85849_();
        }
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        for (ListButton button : this.listButtons) {
            button.tooltip(tooltipLines);
        }
        if (this.sendButton != null) {
            this.sendButton.tooltip(tooltipLines);
        }
        if (!tooltipLines.isEmpty()) {
            pGuiGraphics.m_280677_(this.f_96547_, tooltipLines, Optional.empty(), pMouseX, pMouseY);
        }
        Lighting.m_84931_();
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    private void onDone() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        ++this.ticks;
        this.scrollOld = this.scroll;
        if (this.scroll == 1.0f && this.scrollTarget > 1.0f) {
            this.scrollTarget = 1.0f;
        }
        if (this.scroll == 0.0f && this.scrollTarget < 0.0f) {
            this.scrollTarget = 0.0f;
        }
        float scrollDist = this.listButtons.size() * (this.button_height + this.button_space) - this.scissorArea.height;
        if (this.listButtons.size() > 0) {
            float dist = Mth.m_14154_((float)(scrollDist * this.scrollTarget - scrollDist * this.scroll));
            float scale = dist / scrollDist;
            float speed = scale / 10.0f;
            this.scroll = Mth.m_14036_((float)HexereiUtil.moveTo(this.scroll, this.scrollTarget, Math.max(speed, 0.002f)), (float)0.0f, (float)1.0f);
        } else {
            this.scrollTarget = 0.0f;
            this.scroll = 0.0f;
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.owl != null && this.owl.m_20270_((Entity)this.f_96541_.f_91074_) < 8.0f;
    }

    private class ScissorArea {
        protected int width;
        protected int height;
        private int x;
        private int y;

        public ScissorArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private class ListButton {
        protected int width;
        protected int height;
        private int x;
        public int y;
        private boolean isHovered = false;
        private boolean isDisabled;
        private boolean isSelected;
        private OnPress onPress;
        private OnPress onComplete;
        private ScissorArea scissorArea;
        private String name;
        private boolean isPlayerButton;
        private int index;

        public ListButton(int x, int y, int width, int height, OnPress onPress, OnPress onComplete, ScissorArea scissorArea, String name, boolean isPlayerButton, boolean isDisabled, int index) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onPress = onPress;
            this.onComplete = onComplete;
            this.scissorArea = scissorArea;
            this.name = name;
            this.isPlayerButton = isPlayerButton;
            this.isDisabled = isDisabled;
            this.index = index;
            this.isSelected = index == OwlCourierSendScreen.this.button_selected;
        }

        public boolean isHovered() {
            return this.isHovered;
        }

        public boolean isDisabled() {
            return this.isDisabled;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public int getX() {
            return this.x;
        }

        public int getY(float partialTicks) {
            float scrollLerp = Mth.m_14179_((float)partialTicks, (float)OwlCourierSendScreen.this.scrollOld, (float)OwlCourierSendScreen.this.scroll);
            return this.y - (int)(scrollLerp * (float)(OwlCourierSendScreen.this.listButtons.size() * (OwlCourierSendScreen.this.button_height + OwlCourierSendScreen.this.button_space) - this.scissorArea.height - OwlCourierSendScreen.this.button_space));
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void tooltip(List<Component> list) {
            if (this.isHovered()) {
                if (this.isDisabled()) {
                    list.add((Component)Component.m_237115_((String)"screen.hexerei.owl_send_screen.depot_too_full").m_130948_(Style.f_131099_.m_178520_(0xFFAAAA)));
                } else {
                    list.add((Component)Component.m_237110_((String)(this.isPlayerButton ? "screen.hexerei.owl_send_screen.to_player" : "screen.hexerei.owl_send_screen.to_depot"), (Object[])new Object[]{this.name}).m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
                }
            }
        }

        public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            this.isHovered = pMouseX < this.scissorArea.x || pMouseY < this.scissorArea.y || pMouseX >= this.scissorArea.x + this.scissorArea.width || pMouseY >= this.scissorArea.y + this.scissorArea.height ? false : pMouseX >= this.getX() && pMouseY >= this.getY(pPartialTick) && pMouseX < this.getX() + this.width && pMouseY < this.getY(pPartialTick) + this.height;
            float alpha = 1.0f;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 4.0f);
            pGuiGraphics.m_280588_(this.scissorArea.x, this.scissorArea.y, this.scissorArea.x + this.scissorArea.width, this.scissorArea.y + this.scissorArea.height);
            Minecraft minecraft = Minecraft.m_91087_();
            pGuiGraphics.m_280246_(1.0f, this.isPlayerButton ? 0.75f : 1.0f, 1.0f, alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.m_280027_(OwlCourierSendScreen.this.GUI, this.getX(), this.getY(pPartialTick), this.getWidth(), this.getHeight(), 3, 3, 74, OwlCourierSendScreen.this.button_height, 1, this.getTextureY());
            if (this.isDisabled()) {
                pGuiGraphics.m_280246_(0.5f, 0.5f, 0.5f, 0.5f);
            } else {
                pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            int i = 0xEEEEEE;
            this.renderString(pGuiGraphics, minecraft.f_91062_, i | Mth.m_14167_((float)(alpha * 255.0f)) << 24, pPartialTick);
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.m_280618_();
            pGuiGraphics.m_280168_().m_85849_();
        }

        public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor, float partialTicks) {
            this.renderScrollingString(pGuiGraphics, pFont, 4, pColor, partialTicks);
        }

        private int getTextureY() {
            int i = 165;
            if (this.isSelected()) {
                return i + 34;
            }
            if (this.isDisabled()) {
                return i + 17;
            }
            if (this.isHovered()) {
                return i + 51;
            }
            return i;
        }

        protected static void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, Component pText, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor, float ticks) {
            int i = pFont.m_92852_((FormattedText)pText);
            int j = (pMinY + pMaxY - 9) / 2 + 1;
            int k = pMaxX - pMinX;
            if (i > k) {
                int l = i - k;
                double d0 = (double)ticks / 20.0;
                double d1 = Math.max((double)l * 0.5, 3.0);
                double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1) + Math.PI) / 2.0 + 0.5;
                double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
                pGuiGraphics.m_280588_(pMinX - 1, pMinY, pMaxX + 1, pMaxY);
                pGuiGraphics.m_280430_(pFont, pText, pMinX - (int)d3, j, pColor);
                pGuiGraphics.m_280618_();
            } else {
                pGuiGraphics.m_280653_(pFont, pText, (pMinX + pMaxX) / 2, j, pColor);
            }
        }

        protected void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor, float partialTicks) {
            int i = this.getX() + pWidth;
            int j = this.getX() + this.getWidth() - pWidth;
            ListButton.renderScrollingString(pGuiGraphics, pFont, (Component)Component.m_237113_((String)this.name), i, this.getY(partialTicks), j, this.getY(partialTicks) + this.getHeight(), pColor, (float)OwlCourierSendScreen.this.ticks + partialTicks);
        }

        public void onClick(double pMouseX, double pMouseY) {
            this.onPress.onPress(this);
        }

        public void onRelease(double pMouseX, double pMouseY) {
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            boolean flag;
            if (this.isValidClickButton(pButton) && (flag = this.clicked(pMouseX, pMouseY))) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.onClick(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
            if (this.isValidClickButton(pButton)) {
                this.onRelease(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        protected boolean isValidClickButton(int pButton) {
            return pButton == 0;
        }

        protected boolean clicked(double pMouseX, double pMouseY) {
            return this.isHovered() && !this.isDisabled();
        }

        public static interface OnPress {
            public void onPress(ListButton var1);
        }
    }
}

