/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.fluid.FluidIngredient;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class CauldronEmptyingRecipe
implements Recipe<Wrapper> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final FluidIngredient fluid;
    private final ItemStack output;

    public CauldronEmptyingRecipe(ResourceLocation id, Ingredient input, FluidIngredient fluid, ItemStack output) {
        this.id = id;
        this.input = input;
        this.fluid = fluid;
        this.output = output;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(Wrapper pContainer, Level pLevel) {
        return this.input.test(pContainer.getInput()) && this.fluid.test(pContainer.getFluid());
    }

    public ItemStack assemble(Wrapper pContainer, RegistryAccess pRegistryAccess) {
        return this.m_8043_(pRegistryAccess);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.CAULDRON_EMPTYING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CAULDRON_EMPTYING_TYPE.get();
    }

    public static class Wrapper
    extends RecipeWrapper {
        private final FluidStack fluid;

        public Wrapper(ItemStack stack, FluidStack fluid) {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
            this.fluid = fluid;
            this.m_6836_(0, stack);
        }

        public ItemStack getInput() {
            return this.m_8020_(0);
        }

        public FluidStack getFluid() {
            return this.fluid;
        }
    }

    public static class Serializer
    implements RecipeSerializer<CauldronEmptyingRecipe> {
        public CauldronEmptyingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("input"));
            FluidStack fluid = MixingCauldronRecipe.Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"fluid"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            return new CauldronEmptyingRecipe(pRecipeId, input, FluidIngredient.fromFluidStack(fluid), output);
        }

        @Nullable
        public CauldronEmptyingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            FluidIngredient fluid = FluidIngredient.read(buf);
            ItemStack output = buf.m_130267_();
            return new CauldronEmptyingRecipe(pRecipeId, input, fluid, output);
        }

        public void toNetwork(FriendlyByteBuf buf, CauldronEmptyingRecipe recipe) {
            recipe.input.m_43923_(buf);
            recipe.fluid.write(buf);
            buf.m_130055_(recipe.output);
        }
    }
}

