/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BonemealingCandleEffect
extends AbstractCandleEffect {
    private static final int MAX_TIME = 160;

    @Override
    public void tick(Level level, CandleTile blockEntity, CandleData candleData) {
        if (candleData.lit) {
            if ((float)candleData.cooldown >= 160.0f * candleData.getEffectCooldownMultiplier()) {
                for (int i = 0; i < 3; ++i) {
                    BlockPos crop = this.findCrop(level, blockEntity.m_58899_());
                    if (crop == null) continue;
                    Block block = level.m_8055_(crop).m_60734_();
                    if (level.m_5776_() || !(block instanceof CropBlock)) continue;
                    CropBlock cropBlock = (CropBlock)block;
                    ServerLevel serverLevel = (ServerLevel)level;
                    cropBlock.m_214148_(serverLevel, level.f_46441_, crop, level.m_8055_(crop));
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)crop.m_123341_() + 0.5, (double)crop.m_123342_() + 0.5, (double)crop.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.2);
                }
                candleData.cooldown = 0;
            }
            try {
                if (candleData.effectParticle != null && level.m_5776_() && candleData.effectParticle != null && candleData.effectParticle.size() > 0) {
                    this.particle = ParticleArgument.m_247456_((StringReader)new StringReader(candleData.effectParticle.get(new Random().nextInt(candleData.effectParticle.size()))), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_());
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            candleData.cooldown = (candleData.cooldown + 1) % Integer.MAX_VALUE;
        }
    }

    @Nullable
    public BlockPos findCrop(Level level, BlockPos jarPos) {
        ArrayList<BlockPos> crops = new ArrayList<BlockPos>();
        for (BlockPos pos : area) {
            CropBlock cropBlock;
            Block block;
            BlockPos relativePos = jarPos.m_121955_((Vec3i)pos);
            BlockState state = level.m_8055_(relativePos);
            if (state.m_60795_() || !((block = state.m_60734_()) instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_7370_((LevelReader)level, pos, state, level.f_46443_)) continue;
            crops.add(relativePos);
        }
        if (crops.isEmpty()) {
            return null;
        }
        return (BlockPos)crops.get(level.f_46441_.m_188503_(crops.size()));
    }

    @Override
    public <T> AbstractCandleEffect getCopy() {
        return new BonemealingCandleEffect();
    }

    @Override
    public String getLocationName() {
        return new ResourceLocation("hexerei", "growth_effect").toString();
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.f_123748_;
    }
}

