/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class PonderChapterRegistry {
    private final Map<ResourceLocation, Pair<PonderChapter, List<PonderStoryBoardEntry>>> chapters = new HashMap<ResourceLocation, Pair<PonderChapter, List<PonderStoryBoardEntry>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PonderChapter addChapter(@Nonnull PonderChapter chapter) {
        Map<ResourceLocation, Pair<PonderChapter, List<PonderStoryBoardEntry>>> map = this.chapters;
        synchronized (map) {
            this.chapters.put(chapter.getId(), Pair.of(chapter, new ArrayList()));
        }
        return chapter;
    }

    @Nullable
    PonderChapter getChapter(ResourceLocation id) {
        Pair<PonderChapter, List<PonderStoryBoardEntry>> pair = this.chapters.get(id);
        if (pair == null) {
            return null;
        }
        return pair.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoriesToChapter(@Nonnull PonderChapter chapter, PonderStoryBoardEntry ... entries) {
        List<PonderStoryBoardEntry> entryList;
        List<PonderStoryBoardEntry> list = entryList = this.chapters.get(chapter.getId()).getSecond();
        synchronized (list) {
            Collections.addAll(entryList, entries);
        }
    }

    public List<PonderChapter> getAllChapters() {
        return this.chapters.values().stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    public List<PonderStoryBoardEntry> getStories(PonderChapter chapter) {
        return this.chapters.get(chapter.getId()).getSecond();
    }
}

