/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.trading.MerchantOffers;

public class S2CMerchantDataMessage
implements MessageV2<S2CMerchantDataMessage> {
    private int containerId;
    private int merchantId;
    private Component merchantTitle;
    private MerchantOffers offers;
    private int villagerLevel;
    private int villagerXp;
    private boolean showProgress;
    private boolean canRestock;

    public S2CMerchantDataMessage() {
    }

    public S2CMerchantDataMessage(int containerId, int merchantId, Component merchantTitle, MerchantOffers offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
        this.containerId = containerId;
        this.merchantId = merchantId;
        this.merchantTitle = merchantTitle;
        this.offers = offers;
        this.villagerLevel = villagerLevel;
        this.villagerXp = villagerXp;
        this.showProgress = showProgress;
        this.canRestock = canRestock;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.writeInt(this.merchantId);
        buf.m_130083_(this.merchantTitle);
        this.offers.m_45393_(buf);
        buf.m_130130_(this.villagerLevel);
        buf.m_130130_(this.villagerXp);
        buf.writeBoolean(this.showProgress);
        buf.writeBoolean(this.canRestock);
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        this.merchantId = buf.readInt();
        this.merchantTitle = buf.m_130238_();
        this.offers = MerchantOffers.m_45395_((FriendlyByteBuf)buf);
        this.villagerLevel = buf.m_130242_();
        this.villagerXp = buf.m_130242_();
        this.showProgress = buf.readBoolean();
        this.canRestock = buf.readBoolean();
    }

    public MessageV2.MessageHandler<S2CMerchantDataMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CMerchantDataMessage>(){

            public void handle(S2CMerchantDataMessage packet, Player player, Object gameInstance) {
                AbstractContainerMenu container = player.f_36096_;
                if (packet.containerId == container.f_38840_ && container instanceof TradingPostMenu) {
                    ((TradingPostMenu)container).addMerchant(player, packet.merchantId, packet.merchantTitle, new MerchantOffers(packet.offers.m_45388_()), packet.villagerLevel, packet.villagerXp, packet.showProgress, packet.canRestock);
                }
            }
        };
    }
}

