/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.handler;

import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.client.helper.EffectLinesHelper;
import fuzs.effectdescriptions.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipHandler {
    public static void onItemTooltip(ItemStack stack, @Nullable Player player, List<Component> lines, TooltipFlag context) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addDescriptionsToItemTooltips) {
            return;
        }
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).effectDescriptionItems.contains((Object)stack.m_41720_())) {
            return;
        }
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).holdShiftForItemDescriptions && !Screen.m_96638_()) {
            return;
        }
        Set ids = ItemTooltipHandler.getMobEffects(stack).stream().map(MobEffectInstance::m_19576_).collect(Collectors.toSet());
        for (int i = 0; i < lines.size(); ++i) {
            Component component2;
            Object object;
            Component line = lines.get(i);
            ComponentContents componentContents = line.m_214077_();
            if (!(componentContents instanceof TranslatableContents)) continue;
            TranslatableContents contents = (TranslatableContents)componentContents;
            while (contents.m_237523_().length != 0 && (object = contents.m_237523_()[0]) instanceof Component && (object = (component2 = (Component)object).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents innerContents;
                contents = innerContents = (TranslatableContents)object;
            }
            String id = contents.m_237508_();
            if (!ids.contains(id)) continue;
            int index = i + 1;
            EffectLinesHelper.getEffectDescriptionComponent(id, false).ifPresent(component -> lines.add(index, (Component)component));
        }
    }

    private static List<MobEffectInstance> getMobEffects(ItemStack stack) {
        if (stack.m_150930_(Items.f_42718_)) {
            ArrayList suspiciousStewEffects = Lists.newArrayList();
            ItemTooltipHandler.getSuspiciousStewPotionEffects(stack, suspiciousStewEffects::add);
            return suspiciousStewEffects;
        }
        return PotionUtils.m_43547_((ItemStack)stack);
    }

    private static void getSuspiciousStewPotionEffects(ItemStack itemStack, Consumer<MobEffectInstance> consumer) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("Effects", 9)) {
            ListTag listTag = compoundTag.m_128437_("Effects", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                int j = compoundTag2.m_128425_("EffectDuration", 99) ? compoundTag2.m_128451_("EffectDuration") : 160;
                MobEffect mobEffect = MobEffect.m_19453_((int)compoundTag2.m_128451_("EffectId"));
                if (mobEffect == null) continue;
                consumer.accept(new MobEffectInstance(mobEffect, j));
            }
        }
    }
}

