/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteHelper {
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_TOP_LOG_TEXTURE = s -> {
        if ((s = new ResourceLocation(s).m_135815_()).contains("_overlay")) {
            return false;
        }
        return s.contains("_top") || s.contains("_end") || s.contains("_up");
    };
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_SIDE_LOG_TEXTURE = s -> !LOOKS_LIKE_TOP_LOG_TEXTURE.test(s = new ResourceLocation(s).m_135815_()) && (!s.contains("_overlay") || s.contains("_leaves"));
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_LEAF_TEXTURE = s -> !(s = new ResourceLocation(s).m_135815_()).contains("_top") && !s.contains("_bushy") && !s.contains("_snow") && !s.contains("_overlay") && !s.contains("/snow");

    public static void addHardcodedSprites() {
        TextureCache.registerSpecialTextureForBlock((ItemLike)Blocks.f_50128_, (String)"cactus_log", (ResourceLocation)EveryCompat.res("block/cactus_side"));
        TextureCache.registerSpecialTextureForBlock((ItemLike)Blocks.f_50128_, (String)"cactus_log_top", (ResourceLocation)EveryCompat.res("block/cactus_top"));
        SpriteHelper.addOptional("minecraft:mushroom_stem", "_side", "minecraft:block/mushroom_stem");
        SpriteHelper.addOptional("minecraft:mushroom_stem", "_top", "minecraft:block/mushroom_stem");
        SpriteHelper.addOptional("promenade:sakura_log", "_side", "promenade:block/sakura/log/side");
        SpriteHelper.addOptional("promenade:sakura_log", "_top", "promenade:block/sakura/log/top");
        SpriteHelper.addOptional("promenade:stripped_sakura_log", "_side", "promenade:block/sakura/stripped_log/side");
        SpriteHelper.addOptional("promenade:stripped_sakura_log", "_top", "promenade:block/sakura/stripped_log/top");
        SpriteHelper.addOptional("promenade:dark_amaranth_log", "_side", "promenade:block/dark_amaranth/log/side");
        SpriteHelper.addOptional("promenade:dark_amaranth_log", "_top", "promenade:block/dark_amaranth/log/top");
        SpriteHelper.addOptional("promenade:stripped_dark_amaranth_log", "_side", "promenade:block/dark_amaranth/stripped_log/side");
        SpriteHelper.addOptional("promenade:stripped_dark_amaranth_log", "_top", "promenade:block/dark_amaranth/stripped_log/top");
        SpriteHelper.addOptional("promenade:palm_log", "_side", "promenade:block/palm/log/side");
        SpriteHelper.addOptional("promenade:palm_log", "_top", "promenade:block/palm/log/top");
        SpriteHelper.addOptional("promenade:stripped_palm_log", "_side", "promenade:block/palm/stripped_log/side");
        SpriteHelper.addOptional("promenade:stripped_palm_log", "_top", "promenade:block/palm/stripped_log/top");
        SpriteHelper.addOptional("promenade:maple_log", "_side", "promenade:block/maple/log/side");
        SpriteHelper.addOptional("promenade:maple_log", "_top", "promenade:block/maple/log/top");
        SpriteHelper.addOptional("promenade:stripped_maple_log", "_side", "promenade:block/maple/stripped_log/side");
        SpriteHelper.addOptional("promenade:stripped_maple_log", "_top", "promenade:block/maple/stripped_log/top");
        SpriteHelper.addOptional("promenade:sakura_planks", "_side", "promenade:block/sakura/planks");
        SpriteHelper.addOptional("promenade:dark_amaranth_planks", "_side", "promenade:block/dark_amaranth/planks");
        SpriteHelper.addOptional("promenade:palm_planks", "_side", "promenade:block/palm/planks");
        SpriteHelper.addOptional("promenade:maple_planks", "_side", "promenade:block/maple/planks");
        SpriteHelper.addOptional("simplemango:mango_log", "_top", "simplemango:block/mango_log_horizontal");
        SpriteHelper.addOptional("rainbowoaks:rainbow_leaves", "_leaves", "minecraft:block/oak_leaves");
        SpriteHelper.addOptional("culturaldelights:fruiting_avocado_leaves", "_leaves", "culturaldelights:block/fruiting_avocado_leaves_0");
        SpriteHelper.addOptional("meadow:pine_leaves", "_leaves", "meadow:block/pine_leaves_1");
        SpriteHelper.addOptional("autumnity:red_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        SpriteHelper.addOptional("autumnity:orange_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        SpriteHelper.addOptional("autumnity:yellow_maple_leaves", "_leaves", "autumnity:block/maple_leaves");
        SpriteHelper.addOptional("blue_skies:comet_leaves", "_leaves", "blue_skies:block/leaves/comet_leaves_grown");
        SpriteHelper.addOptional("aether_redux:azure_fieldsproot_leaves", "_leaves", "aether_redux:block/natural/fieldsproot_leaves");
        SpriteHelper.addOptional("integrateddynamics:menril_leaves", "_leaves", "integrateddynamics:block/menril_leaves_fancy");
        SpriteHelper.addOptional("malum:budding_soulwood_leaves", "_leaves", "malum:block/soulwood/budding_soulwood_leaves");
        SpriteHelper.addOptional("malum:azure_runewood_leaves", "_leaves", "malum:block/runewood/azure_runewood_leaves");
        SpriteHelper.addOptional("biomeswevegone:aspen_leaves", "_leaves", "biomeswevegone:block/aspen/leaves");
        SpriteHelper.addOptional("biomeswevegone:baobab_leaves", "_leaves", "biomeswevegone:block/baobab/leaves");
        SpriteHelper.addOptional("biomeswevegone:blue_enchanted_leaves", "_leaves", "biomeswevegone:block/blue_enchanted/leaves");
        SpriteHelper.addOptional("biomeswevegone:cika_leaves", "_leaves", "biomeswevegone:block/cika/leaves");
        SpriteHelper.addOptional("biomeswevegone:cypress_leaves", "_leaves", "biomeswevegone:block/cypress/leaves");
        SpriteHelper.addOptional("biomeswevegone:ebony_leaves", "_leaves", "biomeswevegone:block/ebony/leaves");
        SpriteHelper.addOptional("biomeswevegone:fir_leaves", "_leaves", "biomeswevegone:block/fir/leaves");
        SpriteHelper.addOptional("biomeswevegone:green_enchanted_leaves", "_leaves", "biomeswevegone:block/green_enchanted/leaves");
        SpriteHelper.addOptional("biomeswevegone:holly_leaves", "_leaves", "biomeswevegone:block/holly/leaves");
        SpriteHelper.addOptional("biomeswevegone:ironwood_leaves", "_leaves", "biomeswevegone:block/ironwood/leaves");
        SpriteHelper.addOptional("biomeswevegone:jacaranda_leaves", "_leaves", "biomeswevegone:block/jacaranda/leaves");
        SpriteHelper.addOptional("biomeswevegone:mahongany_leaves", "_leaves", "biomeswevegone:block/mahongany/leaves");
        SpriteHelper.addOptional("biomeswevegone:maple_leaves", "_leaves", "biomeswevegone:block/maple/leaves");
        SpriteHelper.addOptional("biomeswevegone:palm_leaves", "_leaves", "biomeswevegone:block/palm/leaves");
        SpriteHelper.addOptional("biomeswevegone:palo_verde_leaves", "_leaves", "biomeswevegone:block/palo_verde/leaves");
        SpriteHelper.addOptional("biomeswevegone:pine_leaves", "_leaves", "biomeswevegone:block/pine/leaves");
        SpriteHelper.addOptional("biomeswevegone:rainbow_eucalyptus_leaves", "_leaves", "biomeswevegone:block/rainbow_eucalyptus/leaves");
        SpriteHelper.addOptional("biomeswevegone:redwood_leaves", "_leaves", "biomeswevegone:block/redwood/leaves");
        SpriteHelper.addOptional("biomeswevegone:skyris_leaves", "_leaves", "biomeswevegone:block/skyris/leaves");
        SpriteHelper.addOptional("biomeswevegone:white_mangrove_leaves", "_leaves", "biomeswevegone:block/white_mangrove/leaves");
        SpriteHelper.addOptional("biomeswevegone:willow_leaves", "_leaves", "biomeswevegone:block/willow/leaves");
        SpriteHelper.addOptional("biomeswevegone:witch_hazel_leaves", "_leaves", "biomeswevegone:block/witch_hazel/leaves");
        SpriteHelper.addOptional("biomeswevegone:zelkova_leaves", "_leaves", "biomeswevegone:block/zelkova/leaves");
        SpriteHelper.addOptional("eternal_tales:khagris_log", "_side", "eternal_tales:block/khagris_log_new");
        SpriteHelper.addOptional("eternal_tales:khagris_log", "_top", "eternal_tales:block/edemlogtop");
        SpriteHelper.addOptional("eternal_tales:stripped_khagris_log", "_side", "eternal_tales:block/khagris_log_stripped_new");
        SpriteHelper.addOptional("eternal_tales:stripped_khagris_log", "_top", "eternal_tales:block/khagris_log_stripped_top_new");
        SpriteHelper.addOptional("eternal_tales:purgatorium_log", "_side", "eternal_tales:block/purgatorium_log_new");
        SpriteHelper.addOptional("eternal_tales:purgatorium_log", "_top", "eternal_tales:block/purglogtop");
        SpriteHelper.addOptional("eternal_tales:purgatorium_stripped_log", "_side", "eternal_tales:block/purgatorium_stripped_log_new");
        SpriteHelper.addOptional("eternal_tales:purgatorium_stripped_log", "_top", "eternal_tales:block/purgatorium_log_stripped_top_new");
        SpriteHelper.addOptional("eternal_tales:petrified_log", "_side", "eternal_tales:block/petrifiedlogside");
        SpriteHelper.addOptional("eternal_tales:petrified_log", "_top", "eternal_tales:block/petrifiedlogtop");
        SpriteHelper.addOptional("eternal_tales:stripped_petrified_log", "_side", "eternal_tales:block/petrifiedlogsidestripped");
        SpriteHelper.addOptional("eternal_tales:stripped_petrified_log", "_top", "eternal_tales:block/petrifiedlogstrippedtop");
        SpriteHelper.addOptional("eternal_tales:mandarin_orange_log", "_side", "eternal_tales:block/mandarinlog");
        SpriteHelper.addOptional("eternal_tales:mandarin_orange_log", "_top", "eternal_tales:block/mandarinlogtop");
        SpriteHelper.addOptional("eternal_tales:comets_log", "_side", "eternal_tales:block/comets_log_new");
        SpriteHelper.addOptional("eternal_tales:comets_log", "_top", "eternal_tales:block/cometswoodtop");
        SpriteHelper.addOptional("eternal_tales:striped_comets_log", "_side", "eternal_tales:block/comets_log_stripped_new");
        SpriteHelper.addOptional("eternal_tales:striped_comets_log", "_top", "eternal_tales:block/comets_log_stripped_top_new");
        SpriteHelper.addOptional("eternal_tales:carved_pure_wood", "_side", "eternal_tales:block/pure_log_carved_side");
        SpriteHelper.addOptional("eternal_tales:carved_pure_wood", "_top", "eternal_tales:block/pure_log_carved_top");
        SpriteHelper.addOptional("biomesoplenty:null_leaves", "_leaves", "biomesoplenty:block/null_overlay");
        SpriteHelper.addOptional("biomesoplenty:snowblossom_leaves", "_leaves", "biomesoplenty:block/snowblossom_leaves");
        SpriteHelper.addOptional("environmental:pink_wisteria_leaves", "_leaves", "environmental:block/pink_wisteria_leaves");
        SpriteHelper.addOptional("environmental:blue_wisteria_leaves", "_leaves", "environmental:block/blue_wisteria_leaves");
        SpriteHelper.addOptional("environmental:purple_wisteria_leaves", "_leaves", "environmental:block/purple_wisteria_leaves");
        SpriteHelper.addOptional("environmental:white_wisteria_leaves", "_leaves", "environmental:block/white_wisteria_leaves");
        SpriteHelper.addOptional("dawnoftimebuilder:waxed_oak_planks", "_side", "dawnoftimebuilder:block/waxed_oak_planks");
        SpriteHelper.addOptional("dawnoftimebuilder:waxed_oak_planks", "_top", "dawnoftimebuilder:block/waxed_oak_planks");
        SpriteHelper.addOptional("dawnoftimebuilder:charred_spruce_planks", "_side", "dawnoftimebuilder:block/charred_spruce_planks");
        SpriteHelper.addOptional("dawnoftimebuilder:charred_spruce_planks", "_top", "dawnoftimebuilder:block/charred_spruce_planks");
        SpriteHelper.addOptional("shadowlands:vellium_log", "_side", "shadowlands:block/velliumlogside");
        SpriteHelper.addOptional("shadowlands:vellium_log", "_top", "shadowlands:block/log");
        SpriteHelper.addOptional("shadowlands:vellium_planks", "_all", "shadowlands:block/velliumplanks");
        SpriteHelper.addOptional("shadowlands:vellium_leaves", "_top", "shadowlands:block/velliumleaves");
        SpriteHelper.addOptional("midnight:bogshroom_stem", "_side", "midnight:block/bogshroom_cap");
        SpriteHelper.addOptional("midnight:bogshroom_stem", "_top", "midnight:block/bogshroom_cap");
        SpriteHelper.addOptional("midnight:moonshroom_stem", "_side", "midnight:block/moonshroom_cap");
        SpriteHelper.addOptional("midnight:moonshroom_stem", "_top", "midnight:block/moonshroom_cap");
        SpriteHelper.addOptional("midnight:nightshroom_stem", "_side", "midnight:block/nightshroom_cap");
        SpriteHelper.addOptional("midnight:nightshroom_stem", "_top", "midnight:block/nightshroom_cap");
        SpriteHelper.addOptional("midnight:viridshroom_stem", "_side", "midnight:block/viridshroom_cap");
        SpriteHelper.addOptional("midnight:viridshroom_stem", "_top", "midnight:block/viridshroom_cap");
        SpriteHelper.addOptional("midnight:dewshroom_stem", "_side", "midnight:block/dewshroom_cap");
        SpriteHelper.addOptional("midnight:dewshroom_stem", "_top", "midnight:block/dewshroom_cap");
        SpriteHelper.addOptional("aoa3:stranglewood_log", "_side", "aoa3:block/stranglewood_log");
        SpriteHelper.addOptional("aoa3:stranglewood_log", "_top", "aoa3:block/stranglewood_log_top");
        SpriteHelper.addOptional("betterend:lucernia_leaves", "_leaves", "betterend:block/lucernia_leaves_1");
        SpriteHelper.addOptional("betternether:nether_mushroom", "_side", "betternether:block/nether_mushroom_stem_side");
        SpriteHelper.addOptional("mynethersdelight:powdery_block", "_side", "mynethersdelight:block/powdery_block");
        SpriteHelper.addOptional("mynethersdelight:stripped_powdery_block", "_side", "mynethersdelight:block/stripped_powdery_block");
        SpriteHelper.addOptional("piglin_ruins:ominous_stalk_block", "_side", "piglin_ruins:block/ominous_stalk_block_side");
        SpriteHelper.addOptional("piglin_ruins:ominous_stalk_block", "_top", "piglin_ruins:block/ominous_stalk_block_top");
        SpriteHelper.addOptional("piglin_ruins:stripped_ominous_stalk_block", "_side", "piglin_ruins:block/stripped_ominous_stalk_block_side");
        SpriteHelper.addOptional("piglin_ruins:stripped_ominous_stalk_block", "_top", "piglin_ruins:block/stripped_ominous_stalk_block_top");
        SpriteHelper.addOptional("unusualend:chorus_cane_block", "_side", "unusualend:block/chorus_cane_block_side");
        SpriteHelper.addOptional("unusualend:chorus_cane_block", "_top", "unusualend:block/chorus_cane_block_top");
        SpriteHelper.addOptional("unusualend:stripped_chorus_cane_block", "_side", "unusualend:block/stripped_chorus_cane_block_side");
        SpriteHelper.addOptional("unusualend:stripped_chorus_cane_block", "_top", "unusualend:block/stripped_chorus_cane_block_top");
        SpriteHelper.addOptional("ad_astra:strophar_stem", "_side", "ad_astra:block/strophar_stem");
        SpriteHelper.addOptional("ad_astra:strophar_stem", "_top", "ad_astra:block/strophar_stem");
        SpriteHelper.addOptional("ad_astra:aeronos_stem", "_side", "ad_astra:block/aeronos_stem");
        SpriteHelper.addOptional("ad_astra:aeronos_stem", "_top", "ad_astra:block/aeronos_stem");
        SpriteHelper.addOptional("terrestria:sakura_log", "_top", "terrestria:block/sakura_log_section");
        SpriteHelper.addOptional("terrestria:yucca_palm_log", "_top", "terrestria:block/yucca_palm_log_section");
        SpriteHelper.addOptional("theabyss:rena_log", "_top", "theabyss:block/rena_log");
        SpriteHelper.addOptional("theabyss:stripped_rena_log", "_top", "theabyss:block/rena_log");
        SpriteHelper.addOptional("theabyss:luna_log", "_top", "theabyss:block/luna_log");
        SpriteHelper.addOptional("theabyss:stripped_luna_log", "_top", "theabyss:block/luna_log");
        SpriteHelper.addOptional("dreamy_cottage:strawberry_log", "_side", "dreamy_cottage:block/strawberrylogside");
        SpriteHelper.addOptional("dreamy_cottage:strawberry_log", "_top", "dreamy_cottage:block/strawberrylog");
        SpriteHelper.addOptional("dreamy_cottage:stripped_strawberry_log", "_side", "dreamy_cottage:block/strippedlogsidestrawberry");
        SpriteHelper.addOptional("dreamy_cottage:stripped_strawberry_log", "_top", "dreamy_cottage:block/strippedlogstrawberry");
        SpriteHelper.addOptional("dreamy_cottage:white_oak_log", "_side", "dreamy_cottage:block/untitled416_20240420160357_1");
        SpriteHelper.addOptional("dreamy_cottage:white_oak_log", "_top", "dreamy_cottage:block/untitled416_20240420160009_1");
        SpriteHelper.addOptional("dreamy_cottage:stripped_white_oak_log", "_side", "dreamy_cottage:block/strippedwhiteoakside");
        SpriteHelper.addOptional("dreamy_cottage:stripped_white_oak_log", "_top", "dreamy_cottage:block/strippedwhiteoak");
        SpriteHelper.addOptional("dreamy_cottage:strawberry_leaves", "_leaves", "dreamy_cottage:block/whiteoakleaves");
        SpriteHelper.addOptional("dreamy_cottage:white_oak_leaves", "_leaves", "dreamy_cottage:block/whiteoakleaves");
        SpriteHelper.addOptional("feywild:spring_tree_log", "_side", "feywild:block/spring_tree_wood");
        SpriteHelper.addOptional("feywild:spring_tree_log", "_top", "feywild:block/spring_tree_log");
        SpriteHelper.addOptional("feywild:summer_tree_log", "_side", "feywild:block/summer_tree_wood");
        SpriteHelper.addOptional("feywild:summer_tree_log", "_top", "feywild:block/summer_tree_log");
        SpriteHelper.addOptional("feywild:autumn_tree_log", "_side", "feywild:block/autumn_tree_wood");
        SpriteHelper.addOptional("feywild:autumn_tree_log", "_top", "feywild:block/autumn_tree_log");
        SpriteHelper.addOptional("feywild:winter_tree_log", "_side", "feywild:block/winter_tree_wood");
        SpriteHelper.addOptional("feywild:winter_tree_log", "_top", "feywild:block/winter_tree_log");
        SpriteHelper.addOptional("feywild:blossom_tree_log", "_side", "feywild:block/blossom_tree_wood");
        SpriteHelper.addOptional("feywild:blossom_tree_log", "_top", "feywild:block/blossom_tree_log");
        SpriteHelper.addOptional("feywild:hexen_tree_log", "_side", "feywild:block/hexen_tree_wood");
        SpriteHelper.addOptional("feywild:hexen_tree_log", "_top", "feywild:block/hexen_tree_log");
        SpriteHelper.addOptional("born_in_chaos_v1:scorched_log", "_side", "born_in_chaos_v1:block/brievno");
        SpriteHelper.addOptional("born_in_chaos_v1:scorched_log", "_top", "born_in_chaos_v1:block/brievnovierkh1");
        SpriteHelper.addOptional("born_in_chaos_v1:stripped_scorched_log", "_side", "born_in_chaos_v1:block/obdreve");
        SpriteHelper.addOptional("born_in_chaos_v1:stripped_scorched_log", "_top", "born_in_chaos_v1:block/obtes");
        SpriteHelper.addOptional("born_in_chaos_v1:scorched_planks", "_planks", "born_in_chaos_v1:block/opdosk");
        SpriteHelper.addOptional("nue:dragon_stem", "_side", "nue:block/dragonstem");
        SpriteHelper.addOptional("nue:dragon_stem", "_top", "nue:block/dragonstemtop");
        SpriteHelper.addOptional("nue:stripped_dragon_stem", "_side", "nue:block/strippeddragonstem");
        SpriteHelper.addOptional("nue:stripped_dragon_stem", "_top", "nue:block/strippeddragonstemtop");
        SpriteHelper.addOptional("nue:elder_stem", "_side", "nue:block/elderstem");
        SpriteHelper.addOptional("nue:elder_stem", "_top", "nue:block/elderstemtop");
        SpriteHelper.addOptional("nue:stripped_elder_stem", "_side", "nue:block/strippedelderstem");
        SpriteHelper.addOptional("nue:stripped_elder_stem", "_top", "nue:block/strippedelderstemtop");
        SpriteHelper.addOptional("nue:frosted_stem", "_side", "nue:block/frostedstem");
        SpriteHelper.addOptional("nue:frosted_stem", "_top", "nue:block/frostedstem2");
        SpriteHelper.addOptional("nue:stripped_frosted_stem", "_side", "nue:block/strippedfrozenstem");
        SpriteHelper.addOptional("nue:stripped_frosted_stem", "_top", "nue:block/strippedfrozenstemtop");
        SpriteHelper.addOptional("fruitfulfun:apple_leaves", "_leaves", "minecraft:block/oak_leaves");
        SpriteHelper.addOptional("fruitfulfun:cherry_leaves", "_leaves", "fruitfulfun:block/cherry_leaves_2");
        SpriteHelper.addOptional("fruitfulfun:citron_leaves", "_leaves", "fruitfulfun:block/citron_leaves");
        SpriteHelper.addOptional("fruitfulfun:grapefruit_leaves", "_leaves", "fruitfulfun:block/grapefruit_leaves");
        SpriteHelper.addOptional("fruitfulfun:lemon_leaves", "_leaves", "fruitfulfun:block/lemon_leaves");
        SpriteHelper.addOptional("fruitfulfun:lime_leaves", "_leaves", "fruitfulfun:block/lime_leaves");
        SpriteHelper.addOptional("fruitfulfun:orange_leaves", "_leaves", "fruitfulfun:block/orange_leaves");
        SpriteHelper.addOptional("fruitfulfun:pomegranate_leaves", "_leaves", "fruitfulfun:block/pomegranate_leaves");
        SpriteHelper.addOptional("fruitfulfun:pomelo_leaves", "_leaves", "fruitfulfun:block/pomelo_leaves");
        SpriteHelper.addOptional("fruitfulfun:redlove_leaves", "_leaves", "fruitfulfun:block/redlove_leaves");
        SpriteHelper.addOptional("fruitfulfun:tangerine_leaves", "_leaves", "fruitfulfun:block/tangerine_leaves");
        SpriteHelper.addOptional("extendedmushrooms:glowshroom_stem", "_top", "extendedmushrooms:block/glowshroom_stem");
        SpriteHelper.addOptional("extendedmushrooms:poisonous_mushroom_stem", "_top", "extendedmushrooms:block/poisonous_mushroom_stem");
        SpriteHelper.addOptional("extendedmushrooms:stripped_mushroom_stem", "_side", "extendedmushrooms:block/stripped_mushroom_stem");
        SpriteHelper.addOptional("extendedmushrooms:stripped_mushroom_stem", "_top", "extendedmushrooms:block/stripped_mushroom_stem");
        SpriteHelper.addOptional("extendedmushrooms:honey_fungus_stem", "_side", "extendedmushrooms:block/honey_fungus_stem");
        SpriteHelper.addOptional("extendedmushrooms:honey_fungus_stem", "_top", "extendedmushrooms:block/honey_fungus_stem");
        SpriteHelper.addOptional("extendedmushrooms:honey_fungus_stem_stripped", "_side", "extendedmushrooms:block/honey_fungus_stem_stripped");
        SpriteHelper.addOptional("extendedmushrooms:honey_fungus_stem_stripped", "_top", "extendedmushrooms:block/honey_fungus_stem_stripped");
        SpriteHelper.addOptional("vinery:apple_leaves", "_leaves", "vinery:block/apple_leaves_0");
        SpriteHelper.addOptional("vinery:dark_cherry", "_leaves", "vinery:block/dark_cherry_leaves");
        SpriteHelper.addOptional("twilightforest:beanstalk_leaves", "_leaves", "minecraft:block/azalea_leaves");
        SpriteHelper.addOptional("twilightforest:thorn_leaves", "_leaves", "minecraft:block/oak_leaves");
        SpriteHelper.addOptional("regions_unexplored:eucalyptus_log", "_side", "everycomp:block/regions_unexplored/eucalyptus_log");
        SpriteHelper.addOptional("regions_unexplored:alpha_leaves", "_leaves", "regions_unexplored:block/alpha_oak_leaves");
        SpriteHelper.addOptional("regions_unexplored:apple_oak_leaves", "_leaves", "regions_unexplored:block/apple_oak_leaves_stage_0");
        SpriteHelper.addOptional("regions_unexplored:flowering_leaves", "_leaves", "regions_unexplored:item/flowering_leaves");
        SpriteHelper.addOptional("regions_unexplored:palm_leaves", "_leaves", "regions_unexplored:block/palm_leaves_side");
        SpriteHelper.addOptional("regions_unexplored:enchanted_birch_leaves", "_leaves", "regions_unexplored:item/enchanted_birch_leaves");
        SpriteHelper.addOptional("regions_unexplored:silver_birch_leaves", "_leaves", "regions_unexplored:item/silver_birch_leaves");
        SpriteHelper.addOptional("regions_unexplored:small_oak_leaves", "_leaves", "minecraft:block/oak_leaves");
        SpriteHelper.addOptional("endlessbiomes:twisted_stem", "_side", "endlessbiomes:block/twistedlogsidetest");
        SpriteHelper.addOptional("endlessbiomes:twisted_stem", "_top", "endlessbiomes:block/twistedlogtoptest");
        SpriteHelper.addOptional("endlessbiomes:stripped_twisted_stem", "_side", "endlessbiomes:block/twistedstrippedlogsidetest");
        SpriteHelper.addOptional("endlessbiomes:stripped_twisted_stem", "_top", "endlessbiomes:block/twistedstrippedlogtoptest");
        SpriteHelper.addOptional("endlessbiomes:penumbra_stem", "_side", "endlessbiomes:block/penumbrallogsidenewest");
        SpriteHelper.addOptional("endlessbiomes:penumbra_stem", "_top", "endlessbiomes:block/penumbrallogtopnewest");
        SpriteHelper.addOptional("endlessbiomes:stripped_penumbra_stem", "_side", "endlessbiomes:block/strippedpenumbralogsidenewest");
        SpriteHelper.addOptional("endlessbiomes:stripped_penumbra_stem", "_top", "endlessbiomes:block/strippedpenumbralogtopnewest");
        SpriteHelper.addOptional("gardens_of_the_dead:whistlecane", "_side", "gardens_of_the_dead:block/whistlecane_block");
        SpriteHelper.addOptional("gardens_of_the_dead:whistlecane", "_top", "gardens_of_the_dead:block/whistlecane_block_top");
        SpriteHelper.addOptional("gardens_of_the_dead:stripped_soulblight_stem", "_side", "gardens_of_the_dead:block/stripped_soulblight_stem");
        SpriteHelper.addOptional("gardens_of_the_dead:stripped_soulblight_stem", "_top", "gardens_of_the_dead:block/stripped_soulblight_stem_top");
        SpriteHelper.addOptional("cataclysm:chorus_stem", "_side", "cataclysm:block/chorus_stem");
        SpriteHelper.addOptional("cataclysm:chorus_stem", "_top", "cataclysm:block/chorus_stem");
        SpriteHelper.addOptional("pfw_aesthetic_gems:ice_blue_topaz_log", "_side", "pfw_aesthetic_gems:block/ice_blue_topaz_log");
        SpriteHelper.addOptional("pfw_aesthetic_gems:ice_blue_topaz_log", "_top", "pfw_aesthetic_gems:block/ice_blue_topaz_log_top");
        SpriteHelper.addOptional("pfw_aesthetic_gems:stripped_ice_blue_topaz_log", "_side", "pfw_aesthetic_gems:block/stripped_ice_blue_topaz_log");
        SpriteHelper.addOptional("pfw_aesthetic_gems:stripped_ice_blue_topaz_log", "_top", "pfw_aesthetic_gems:block/stripped_ice_blue_topaz_log_top");
        SpriteHelper.addOptional("pfw_aesthetic_gems:pink_topaz_log", "_side", "pfw_aesthetic_gems:block/pink_topaz_log");
        SpriteHelper.addOptional("pfw_aesthetic_gems:pink_topaz_log", "_top", "pfw_aesthetic_gems:block/pink_topaz_log_top");
        SpriteHelper.addOptional("pfw_aesthetic_gems:stripped_pink_topaz_log", "_side", "pfw_aesthetic_gems:block/stripped_pink_topaz_log");
        SpriteHelper.addOptional("pfw_aesthetic_gems:stripped_pink_topaz_log", "_top", "pfw_aesthetic_gems:block/stripped_pink_topaz_log_top");
    }

    private static void addOptional(String blockId, String textureId, String texturePath) {
        BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(blockId)).ifPresent(b -> TextureCache.registerSpecialTextureForBlock((ItemLike)b, (String)textureId, (ResourceLocation)new ResourceLocation(texturePath)));
    }

    @Nullable
    public static Supplier<TextureImage> maybePostProcessWoodTexture(WoodType wood, String newId, ResourceManager manager, Supplier<TextureImage> textureSupplier) {
        if (wood.getNamespace().equals("ecologics")) {
            return () -> {
                TextureImage t = (TextureImage)textureSupplier.get();
                SpriteHelper.maybeFlowerAzalea(t, manager, wood);
                return t;
            };
        }
        if (wood.getNamespace().equals("regions_unexplored")) {
            return () -> {
                TextureImage t = (TextureImage)textureSupplier.get();
                SpriteHelper.maybeBrimwood(t, manager, newId, wood);
                return t;
            };
        }
        if (wood.getNamespace().equals("aoa3")) {
            return () -> {
                TextureImage t = (TextureImage)textureSupplier.get();
                SpriteHelper.maybeStrangewood(t, manager, wood);
                return t;
            };
        }
        return null;
    }

    private static void maybeFlowerAzalea(TextureImage image, ResourceManager manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("failed to apply azalea overlay for wood type {} and image {}", (Object)woodType, (Object)image);
            }
        }
    }

    private static void maybeBrimwood(TextureImage image, ResourceManager manager, String path, WoodType woodType) {
        WoodType brimwood;
        if (woodType.getId().toString().equals("regions_unexplored:brimwood") && (brimwood = WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("regions_unexplored:brimwood"))) != null) {
            try (TextureImage lavaOverlay = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_planks_lava"));
                 TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_planks"));){
                String type;
                Respriter respriter = switch (type = path.substring(path.lastIndexOf("brimwood_") + 9)) {
                    case "barrel_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_barrel_side_m")));
                    case "barrel_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_barrel_top_m")));
                    case "beehive_front_honey" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_beehive_front_honey_m")));
                    case "beehive_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_beehive_side_m")));
                    case "bookshelf" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_bookshelf_m")));
                    case "cartography_table_side1" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_side1_m")));
                    case "cartography_table_side2" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_side2_m")));
                    case "cartography_table_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_cartography_table_top_m")));
                    case "chiseled_bookshelf_occupied" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_chiseled_bookshelf_occupied_m")));
                    case "crafting_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_crafting_table_front_m")));
                    case "crafting_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_crafting_table_side_m")));
                    case "fletching_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_front_m")));
                    case "fletching_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_side_m")));
                    case "fletching_table_top" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_fletching_table_top_m")));
                    case "lectern_base" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_lectern_base_m")));
                    case "lectern_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_lectern_front_m")));
                    case "smithing_table_bottom" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_bottom_m")));
                    case "smithing_table_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_front_m")));
                    case "smithing_table_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smithing_table_side_m")));
                    case "smoker_bottom" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smoker_bottom_m")));
                    case "smoker_front" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smoker_front_m")));
                    case "smoker_side" -> Respriter.masked((TextureImage)image, (TextureImage)TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/brimwood_smoker_side_m")));
                    default -> Respriter.of((TextureImage)image);
                };
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                if (path.contains("stairs") || path.contains("planks") || path.contains("slab") || path.contains("beehive") || path.contains("composter_bottom") || path.contains("composter_side") || path.contains("lectern_side") || path.contains("lectern_top") || path.contains("bookshelf_side") || path.contains("bookshelf_top")) {
                    image.applyOverlayOnExisting(new TextureImage[]{temp, lavaOverlay});
                } else {
                    image.applyOverlayOnExisting(new TextureImage[]{temp});
                }
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to process {}'s texture: {}", (Object)path, (Object)e);
            }
        }
    }

    private static void maybeStrangewood(TextureImage image, ResourceManager manager, WoodType woodType) {
        WoodType strangewood;
        if (woodType.getId().toString().equals("aoa3:strangewood") && (strangewood = WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("aoa3:strangewood"))) != null) {
            try (TextureImage vineOverlay = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("aoa3:block/stranglewood_log_vine"));
                 TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)strangewood.log, LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(logTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, vineOverlay});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("Failed to apply vineOverlay for strangewood texture: {}", (Object)String.valueOf(e));
            }
        }
    }
}

