/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeAttributeModifier
extends AbilityTypeAdapter {
    private final String attributeId;
    private final Attribute attribute;
    private final double amountFactor;
    private final AttributeModifier.Operation operation;
    private final Map<Integer, AttributeModifier> attributeModifiers;

    public AbilityTypeAttributeModifier(ICondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, String attributeId, double amountFactor, AttributeModifier.Operation operation) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.attributeId = attributeId;
        this.attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeId));
        if (this.attribute == null) {
            EverlastingAbilities.clog(Level.INFO, "No attribute was found with id: " + attributeId + ". Marking as disabled.");
            this.setCondition((ICondition)FalseCondition.INSTANCE);
        }
        this.amountFactor = amountFactor;
        this.operation = operation;
        this.attributeModifiers = Maps.newHashMap();
        for (int i = 1; i <= maxLevel; ++i) {
            this.attributeModifiers.put(i, new AttributeModifier("everlastingabilities:modifier_" + name + "_" + i, this.amountFactor * (double)i, this.operation));
        }
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public double getAmountFactor() {
        return this.amountFactor;
    }

    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    @Override
    public Codec<? extends IAbilityType> codec() {
        return Objects.requireNonNull(RegistryEntries.ABILITYSERIALIZER_ATTRIBUTE_MODIFIER);
    }

    @Override
    public void onTick(Player player, int level) {
        AttributeModifier modifier;
        super.onTick(player, level);
        AttributeInstance attribute = player.m_21051_(this.attribute);
        if (attribute != null && !attribute.m_22109_(modifier = this.attributeModifiers.get(level))) {
            attribute.m_22118_(modifier);
        }
    }

    @Override
    public void onChangedLevel(Player player, int oldLevel, int newLevel) {
        AttributeInstance attribute = player.m_21051_(this.attribute);
        if (attribute != null) {
            if (oldLevel > 0) {
                attribute.m_22130_(this.attributeModifiers.get(oldLevel));
            }
            if (newLevel > 0) {
                attribute.m_22118_(this.attributeModifiers.get(newLevel));
            }
        }
    }
}

