/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NBTMapHelper<K, KNBT extends Tag, V, VNBT extends Tag> {
    private static final String KEY = "k";
    private static final String VALUE = "v";
    private final String name;
    private final Function<K, KNBT> keyWriter;
    private final Function<KNBT, K> keyReader;
    private final Function<V, VNBT> valueWriter;
    private final Function<VNBT, V> valueReader;

    public NBTMapHelper(String name, Function<K, KNBT> keyWriter, Function<KNBT, K> keyReader, Function<V, VNBT> valueWriter, Function<VNBT, V> valueReader) {
        this.name = name;
        this.keyReader = keyReader;
        this.keyWriter = keyWriter;
        this.valueReader = valueReader;
        this.valueWriter = valueWriter;
    }

    public boolean hasData(CompoundTag nbt) {
        return nbt.m_128441_(this.name);
    }

    public Map<K, V> read(CompoundTag nbt) {
        HashMap newMap = new HashMap();
        ListTag entryList = nbt.m_128437_(this.name, 10);
        if (entryList == null) {
            return newMap;
        }
        int entryCount = entryList.size();
        if (entryCount <= 0) {
            return newMap;
        }
        IntStream.range(0, entryCount).mapToObj(i -> entryList.m_128728_(i)).forEach(entryNBT -> this.writeEntry(newMap, (CompoundTag)entryNBT));
        return newMap;
    }

    private void writeEntry(Map<K, V> map, CompoundTag entryNBT) {
        K key = this.keyReader.apply(entryNBT.m_128423_(KEY));
        V value = this.valueReader.apply(entryNBT.m_128423_(VALUE));
        map.put(key, value);
    }

    public CompoundTag write(Map<K, V> map, CompoundTag compound) {
        ListTag entryListTag = new ListTag();
        map.entrySet().forEach(entry -> this.writeEntry(entryListTag, (Map.Entry<K, V>)entry));
        compound.m_128365_(this.name, (Tag)entryListTag);
        return compound;
    }

    private void writeEntry(ListTag entryListTag, Map.Entry<K, V> entry) {
        CompoundTag entryNBT = new CompoundTag();
        entryNBT.m_128365_(KEY, (Tag)this.keyWriter.apply(entry.getKey()));
        entryNBT.m_128365_(VALUE, (Tag)this.valueWriter.apply(entry.getValue()));
        entryListTag.add((Object)entryNBT);
    }
}

