/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.client.jei;

import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.ShapedBagUpgradeRecipe;
import commoble.bagofyurting.ShapelessBagUpgradeRecipe;
import commoble.bagofyurting.client.jei.JEIUpgradeRecipeHacks;
import java.util.ArrayList;
import java.util.function.IntFunction;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("bagofyurting", "bagofyurting");
    public static final ResourceLocation UPGRADE_RECIPE_ID = new ResourceLocation("bagofyurting", "bag_of_yurting_upgrade");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)BagOfYurtingMod.get().bagOfYurtingItem.get(), JEIProxy::getBagOfYurtingSubtype);
    }

    private static String getBagOfYurtingSubtype(ItemStack stack, UidContext context) {
        return Integer.toString(((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).getRadius(stack));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        manager.m_44043_(UPGRADE_RECIPE_ID).ifPresent(recipe -> JEIProxy.registerExtraRecipes(recipe, registration));
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, IRecipeRegistration registration) {
        IntFunction<CraftingRecipe> recipeFactory = null;
        if (baseRecipe instanceof ShapedBagUpgradeRecipe) {
            recipeFactory = i -> JEIUpgradeRecipeHacks.getFakeShapedRecipe((ShapedBagUpgradeRecipe)baseRecipe, i);
        } else if (baseRecipe instanceof ShapelessBagUpgradeRecipe) {
            recipeFactory = i -> JEIUpgradeRecipeHacks.getFakeShapelessRecipe((ShapelessBagUpgradeRecipe)baseRecipe, i);
        } else {
            return;
        }
        ArrayList<CraftingRecipe> extraRecipes = new ArrayList<CraftingRecipe>();
        int iterations = (Integer)BagOfYurtingMod.get().serverConfig().creativeUpgradeIterations().get();
        for (int i2 = 2; i2 < iterations; ++i2) {
            extraRecipes.add(recipeFactory.apply(i2));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
    }
}

