/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.IsWasSprintPacket;
import commoble.bagofyurting.OptionalSpawnParticlePacket;
import commoble.bagofyurting.ServerConfig;
import commoble.bagofyurting.ShapedBagUpgradeRecipe;
import commoble.bagofyurting.ShapelessBagUpgradeRecipe;
import commoble.bagofyurting.client.ClientProxy;
import commoble.bagofyurting.storage.StorageManager;
import commoble.bagofyurting.util.ConfigHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="bagofyurting")
public class BagOfYurtingMod {
    public static final String MODID = "bagofyurting";
    private static BagOfYurtingMod instance;
    private final ServerConfig serverConfig;
    public static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel CHANNEL;
    public final RegistryObject<BagOfYurtingItem> bagOfYurtingItem;
    public final RegistryObject<RecipeSerializer<ShapedRecipe>> shapedUpgradeRecipeSerializer;
    public final RegistryObject<RecipeSerializer<ShapelessRecipe>> shapelessUpgradeRecipeSerializer;

    public static BagOfYurtingMod get() {
        return instance;
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    public BagOfYurtingMod() {
        instance = this;
        this.serverConfig = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::create);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DeferredRegister items = BagOfYurtingMod.makeDeferredRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister recipeSerializers = BagOfYurtingMod.makeDeferredRegister(modBus, ForgeRegistries.RECIPE_SERIALIZERS);
        this.bagOfYurtingItem = items.register("bag_of_yurting", () -> new BagOfYurtingItem(new Item.Properties().m_41487_(1)));
        this.shapedUpgradeRecipeSerializer = recipeSerializers.register("shaped_bag_of_yurting_upgrade", () -> new ShapedBagUpgradeRecipe.Serializer());
        this.shapelessUpgradeRecipeSerializer = recipeSerializers.register("shapeless_bag_of_yurting_upgrade", () -> new ShapelessBagUpgradeRecipe.Serializer());
        modBus.addListener(this::onBuildCreativeTabs);
        modBus.addListener(this::onCommonSetup);
        forgeBus.addListener(this::onLevelSave);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.subscribeClientEvents(modBus, forgeBus);
        }
    }

    private static <T> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            BagOfYurtingItem item = (BagOfYurtingItem)((Object)this.bagOfYurtingItem.get());
            ItemStack baseStack = new ItemStack((ItemLike)item);
            for (int i = 0; i < 7; ++i) {
                event.m_246342_(item.withRadius(baseStack, i));
            }
        }
    }

    void onCommonSetup(FMLCommonSetupEvent event) {
        int packetID = 0;
        CHANNEL.registerMessage(packetID++, IsWasSprintPacket.class, IsWasSprintPacket::write, IsWasSprintPacket::read, IsWasSprintPacket::handle);
        CHANNEL.registerMessage(packetID++, OptionalSpawnParticlePacket.class, ClientboundLevelParticlesPacket::m_5779_, OptionalSpawnParticlePacket::read, OptionalSpawnParticlePacket::handle);
    }

    void onLevelSave(LevelEvent.Save event) {
        LevelAccessor Level2 = event.getLevel();
        if (Level2 instanceof ServerLevel) {
            StorageManager.onSave((ServerLevel)Level2);
        }
    }

    static {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    public static final class Tags {
        private Tags() {
        }

        public static final class Blocks {
            public static final TagKey<Block> WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("bagofyurting", "whitelist"));
            public static final TagKey<Block> BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("bagofyurting", "blacklist"));
            public static final TagKey<Block> REPLACEABLE = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("bagofyurting", "replaceable"));

            private Blocks() {
            }
        }
    }
}

