/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingData;
import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.storage.DataIdNBTHelper;
import commoble.bagofyurting.storage.StorageManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BagOfYurtingItem
extends Item
implements DyeableLeatherItem {
    public static final String RADIUS_KEY = "radius";
    public static final int UNDYED_COLOR = 0xFFFFFF;

    public BagOfYurtingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return BagOfYurtingItem.getDataReader(stack) != null;
    }

    public int getRadius(ItemStack stack) {
        return stack.m_41784_().m_128451_(RADIUS_KEY);
    }

    public int getDiameter(ItemStack stack) {
        return this.getRadius(stack) * 2 + 1;
    }

    public ItemStack withRadius(ItemStack stack, int radius) {
        ItemStack newStack = stack.m_41777_();
        newStack.m_41784_().m_128405_(RADIUS_KEY, radius);
        return newStack;
    }

    @Nullable
    public static Function<MinecraftServer, BagOfYurtingData> getDataReader(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (DataIdNBTHelper.contains(nbt)) {
            return server -> {
                String dataId = DataIdNBTHelper.get(nbt);
                return StorageManager.load(server, dataId);
            };
        }
        if (BagOfYurtingData.doesNBTContainYurtData(nbt)) {
            return server -> BagOfYurtingData.read(nbt);
        }
        return null;
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag CompoundTag2 = stack.m_41737_("display");
        return CompoundTag2 != null && CompoundTag2.m_128425_("color", 99) ? CompoundTag2.m_128451_("color") : 0xFFFFFF;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level Level2 = context.m_43725_();
        if (Level2 instanceof ServerLevel) {
            Function<MinecraftServer, BagOfYurtingData> dataGetter = BagOfYurtingItem.getDataReader(context.m_43722_());
            MinecraftServer server = ((ServerLevel)Level2).m_7654_();
            if (dataGetter == null) {
                this.loadBag(server, context);
            } else {
                this.unloadBag(context, dataGetter.apply(server));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void loadBag(MinecraftServer server, UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        ItemStack oldStack = context.m_43723_().m_21120_(hand);
        BagOfYurtingData data = BagOfYurtingData.yurtBlocksAndConvertToData(context, this.getRadius(oldStack));
        if (!data.isEmpty()) {
            String id = DataIdNBTHelper.generate(server);
            StorageManager.save(id, data);
            ItemStack newStack = oldStack.m_41777_();
            DataIdNBTHelper.set(newStack.m_41784_(), id);
            context.m_43723_().m_21008_(context.m_43724_(), newStack);
        } else {
            context.m_43723_().m_5661_((Component)Component.m_237115_((String)"bagofyurting.failure.load"), true);
        }
    }

    public void unloadBag(UseOnContext context, BagOfYurtingData data) {
        InteractionHand hand = context.m_43724_();
        ItemStack oldStack = context.m_43723_().m_21120_(hand);
        boolean success = data.attemptUnloadIntoLevel(context, this.getRadius(oldStack));
        if (success) {
            ItemStack newStack = oldStack.m_41777_();
            CompoundTag tag = newStack.m_41784_();
            tag.m_128365_("yurtdata", (Tag)new CompoundTag());
            String id = DataIdNBTHelper.remove(tag);
            if (id != null) {
                StorageManager.remove(id);
            }
            context.m_43723_().m_21008_(context.m_43724_(), newStack);
        } else {
            context.m_43723_().m_5661_((Component)Component.m_237115_((String)"bagofyurting.failure.unload"), true);
        }
    }

    public static ItemStack getUpgradeRecipeResult(List<ItemStack> inputs, ItemStack baseOutput) {
        ItemStack output = baseOutput.m_41777_();
        int bagRadius = Integer.MAX_VALUE;
        boolean foundBag = false;
        ArrayList<Integer> dyes = new ArrayList<Integer>();
        for (ItemStack stack : inputs) {
            Item item = stack.m_41720_();
            if (!(item instanceof BagOfYurtingItem)) continue;
            foundBag = true;
            int newRadius = ((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).getRadius(stack);
            if (((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).m_41113_(stack)) {
                dyes.add(((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).m_41121_(stack));
            }
            if (newRadius >= bagRadius) continue;
            bagRadius = newRadius;
        }
        if (!foundBag) {
            bagRadius = 0;
        }
        ItemStack actualOutput = ((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).withRadius(output, bagRadius + 1);
        int colors = dyes.size();
        if (colors > 0) {
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            Iterator iterator = dyes.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                redSum += color >> 16 & 0xFF;
                greenSum += color >> 8 & 0xFF;
                blueSum += color & 0xFF;
            }
            int finalRed = redSum / colors << 16;
            int finalGreen = greenSum / colors << 8;
            int finalBlue = blueSum / colors & 0xFF;
            int finalColor = finalRed + finalGreen + finalBlue;
            ((BagOfYurtingItem)((Object)BagOfYurtingMod.get().bagOfYurtingItem.get())).m_41115_(actualOutput, finalColor);
        }
        return actualOutput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level LevelIn, List<Component> tooltip, TooltipFlag flagIn) {
        int diameter = this.getDiameter(stack);
        String sizeText = String.format("%sx%sx%s", diameter, diameter, diameter);
        tooltip.add((Component)Component.m_237113_((String)sizeText).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131157_(ChatFormatting.GRAY)));
    }
}

