/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LoveLanternBlockEntity
extends LanternBlockEntity {
    public LoveLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.LOVE_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LoveLanternBlockEntity blockEntity) {
        ServerConfig.LoveLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).loveLantern;
        if (++blockEntity.count <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        List nearbyAnimals = level.m_45976_(Animal.class, new AABB((double)(pos.m_123341_() - horizontalRange), (double)(pos.m_123342_() - verticalRange), (double)(pos.m_123343_() - horizontalRange), (double)(pos.m_123341_() + horizontalRange), (double)(pos.m_123342_() + verticalRange), (double)(pos.m_123343_() + horizontalRange)));
        Collection<List<Animal>> animalsByType = nearbyAnimals.stream().collect(Collectors.groupingBy(Entity::m_6095_)).values();
        for (List<Animal> animals : animalsByType) {
            if (animals.size() > config.maxAnimals) continue;
            animals.removeIf(animal -> animal.m_146764_() != 0 || !animal.m_5957_());
            if (animals.size() < 2) continue;
            Collections.shuffle(animals);
            for (int i = 0; i < 2; ++i) {
                animals.get(i).m_27595_(null);
            }
        }
        blockEntity.count = 0;
    }
}

