/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class PlatformDataSet {
    private final EnumPlatformType type;
    private final String worldDirection;
    private final String worldSubType;
    private final String worldVariant;
    public final ItemStack itemStack;
    public final ResourceLocation texture;
    private final boolean isWalkway;
    private boolean isEdge;
    private final boolean[] hasChanges = new boolean[3];
    private String newDirection;
    private String newSubType;
    private String newVariant;
    public boolean toRemove;
    public boolean toPlace;

    public PlatformDataSet(EnumPlatformType type, BlockState state, Level world, BlockPos pos, Player player) {
        this.type = type;
        this.worldDirection = ((Direction)state.m_61143_((Property)BlockPlatformBase.FACING)).m_7912_();
        String subType = BlockPlatformBase.getPlatformSubType(state).m_7912_();
        this.isWalkway = type == EnumPlatformType.FLAT || type == EnumPlatformType.FLOOR;
        this.isEdge = subType.startsWith("edge");
        if (this.isWalkway) {
            if (subType.contains("_")) {
                String[] split = subType.split("_");
                this.worldSubType = split[0];
                this.worldVariant = split[1].length() == 2 ? split[1] : String.format("%c%c", Character.valueOf(split[1].charAt(0)), Character.valueOf(split[1].charAt(0)));
            } else {
                this.worldSubType = subType;
                this.worldVariant = "nn";
            }
        } else {
            this.worldSubType = subType;
            this.worldVariant = type.m_7912_();
        }
        this.itemStack = state.getCloneItemStack(null, (BlockGetter)world, pos, player);
        AtomicReference<ResourceLocation> location = new AtomicReference<ResourceLocation>(new ResourceLocation("block/oak_planks"));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> location.set(this.getTexture()));
        this.texture = new ResourceLocation(location.get().m_135827_(), "textures/" + location.get().m_135815_() + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation getTexture() {
        return CacheBuilder.INSTANCE.getTextureSprite(ItemBlockPlatform.getCoverTextureStack(this.itemStack)).m_245424_().m_246162_();
    }

    public boolean isWalkway() {
        return this.isWalkway;
    }

    public boolean isEdge() {
        return this.isEdge;
    }

    public boolean hasAlternatives() {
        return this.type.hasAlternatives();
    }

    public EnumPlatformType[] getAlternatives() {
        return this.type.getAlternatives();
    }

    public String getDirection() {
        return this.newDirection != null ? this.newDirection : this.worldDirection;
    }

    public void setDirection(String direction) {
        if (direction != null && Direction.m_122402_((String)direction) != null) {
            this.newDirection = direction;
            this.hasChanges[0] = true;
        } else {
            this.hasChanges[0] = false;
            this.newDirection = null;
        }
    }

    public String getSubType() {
        return this.newSubType != null ? this.newSubType : this.worldSubType;
    }

    public void setSubType(String subType) {
        if (subType != null && subType.contains("_")) {
            subType = subType.substring(0, subType.indexOf("_"));
        }
        if (subType != null && EnumSubType.SIMPLE_LOOKUP.get(subType) != null) {
            this.newSubType = subType;
            this.hasChanges[1] = true;
        } else {
            this.hasChanges[1] = false;
            this.newSubType = null;
        }
        this.isEdge = this.getSubType().startsWith("edge");
    }

    public String getVariant() {
        return this.newVariant != null ? this.newVariant : this.worldVariant;
    }

    public void setVariant(String variant) {
        if (this.isWalkway) {
            if (variant != null) {
                if (variant.contains("_")) {
                    variant = variant.substring(variant.lastIndexOf("_"));
                }
                String string = variant.length() == 2 ? variant : (variant = String.format("%c%c", Character.valueOf(variant.charAt(0)), Character.valueOf(variant.charAt(variant.length() > 2 ? 1 : 0))));
            }
            if (variant != null && variant.matches("[nsew][nsew]")) {
                this.newVariant = variant;
                this.hasChanges[2] = true;
            } else {
                this.hasChanges[2] = false;
                this.newVariant = null;
            }
        } else if (this.hasAlternatives()) {
            if (variant != null) {
                this.newVariant = variant;
                this.hasChanges[2] = true;
            } else {
                this.hasChanges[2] = false;
                this.newVariant = null;
            }
        }
    }

    public boolean hasChanges() {
        return this.hasChanges[0] || this.hasChanges[1] || this.hasChanges[2];
    }

    public boolean isChanged(int index) {
        return this.hasChanges[index];
    }

    public void reset() {
        this.hasChanges[2] = false;
        this.hasChanges[1] = false;
        this.hasChanges[0] = false;
        this.newDirection = null;
        this.newSubType = null;
        this.newVariant = null;
        this.isEdge = this.getSubType().startsWith("edge");
    }

    public CompoundTag write(CompoundTag nbt) {
        Direction direction;
        if (this.toRemove) {
            nbt.m_128379_("remove", true);
        }
        if (this.toPlace) {
            nbt.m_128379_("place", true);
            nbt.m_128365_("stack", (Tag)this.itemStack.m_41739_(new CompoundTag()));
        }
        if ((this.toPlace || this.hasChanges[0]) && (direction = Direction.m_122402_((String)this.getDirection())) != null) {
            nbt.m_128344_("direction", (byte)direction.m_122416_());
        }
        if (this.toPlace || this.hasChanges[1] || (this.isWalkway || this.hasAlternatives()) && this.hasChanges[2]) {
            Object subType = this.getSubType();
            String variant = this.getVariant();
            if (!Strings.isNullOrEmpty((String)subType)) {
                EnumSubType enumSubType;
                if (this.isWalkway) {
                    if (variant != null && !variant.equals("nn") && variant.length() == 2) {
                        subType = (String)subType + "_" + (Serializable)(variant.charAt(0) == variant.charAt(1) ? Character.valueOf(variant.charAt(0)) : variant);
                    }
                    enumSubType = EnumSubType.WALKWAY_LOOKUP.get(subType);
                } else if (this.hasAlternatives()) {
                    enumSubType = EnumSubType.SIMPLE_LOOKUP.get(subType);
                    EnumPlatformType enumPlatformType = EnumPlatformType.LOOKUP.get(variant);
                    if (enumPlatformType != null) {
                        nbt.m_128344_("type", (byte)enumPlatformType.ordinal());
                    }
                } else {
                    enumSubType = EnumSubType.SIMPLE_LOOKUP.get(subType);
                }
                if (enumSubType != null) {
                    nbt.m_128344_("subtype", (byte)enumSubType.ordinal());
                }
            }
        }
        return nbt;
    }
}

