/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import fuzs.betteranimationscollection.client.model.HumanoidKneesModel;
import fuzs.betteranimationscollection.client.model.KneesModel;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class PiglinKneesModel<T extends Mob>
extends PiglinModel<T>
implements KneesModel {
    private final ModelPart rightShin;
    private final ModelPart leftShin;
    private final ModelPart rightPants;
    private final ModelPart leftPants;
    private final ModelPart rightLowerPants;
    private final ModelPart leftLowerPants;

    public PiglinKneesModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightLeg = modelPart.m_171324_("right_leg");
        this.rightShin = rightLeg.m_171324_("right_shin");
        ModelPart leftLeg = modelPart.m_171324_("left_leg");
        this.leftShin = leftLeg.m_171324_("left_shin");
        this.rightPants = modelPart.m_171324_("right_pants");
        this.rightLowerPants = this.rightPants.m_171324_("right_lower_pants");
        this.leftPants = modelPart.m_171324_("left_pants");
        this.leftLowerPants = this.leftPants.m_171324_("left_lower_pants");
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        MeshDefinition meshDefinition = PiglinModel.m_170811_((CubeDeformation)CubeDeformation.f_171458_);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        Pair<CubeListBuilder, PartPose> rightLeg = HumanoidKneesModel.createShin(0, 16, -1.9f, 0.0f, 0.0f, false, CubeDeformation.f_171458_);
        Pair<CubeListBuilder, PartPose> leftLeg = HumanoidKneesModel.createShin(16, 48, 1.9f, 0.0f, 0.0f, true, CubeDeformation.f_171458_);
        Pair<CubeListBuilder, PartPose> rightShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, false, CubeDeformation.f_171458_);
        Pair<CubeListBuilder, PartPose> leftShin = HumanoidKneesModel.createShin(16, 54, 0.0f, -6.0f, -2.0f, true, CubeDeformation.f_171458_);
        PartDefinition partDefinition1 = partDefinition.m_171599_("right_leg", (CubeListBuilder)rightLeg.left(), (PartPose)rightLeg.right());
        PartDefinition partDefinition2 = partDefinition.m_171599_("left_leg", (CubeListBuilder)leftLeg.left(), (PartPose)leftLeg.right());
        partDefinition1.m_171599_("right_shin", (CubeListBuilder)rightShin.left(), (PartPose)rightShin.right());
        partDefinition2.m_171599_("left_shin", (CubeListBuilder)leftShin.left(), (PartPose)leftShin.right());
        CubeDeformation cubeDeformation = new CubeDeformation(0.25f);
        Pair<CubeListBuilder, PartPose> rightPants = HumanoidKneesModel.createShin(0, 32, -1.9f, 0.0f, 0.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftPants = HumanoidKneesModel.createShin(0, 48, 1.9f, 0.0f, 0.0f, true, cubeDeformation);
        Pair<CubeListBuilder, PartPose> rightLowerPants = HumanoidKneesModel.createShin(0, 38, 0.0f, -6.0f, -2.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftLowerPants = HumanoidKneesModel.createShin(0, 54, 0.0f, -6.0f, -2.0f, true, cubeDeformation);
        PartDefinition partDefinition11 = partDefinition.m_171599_("right_pants", (CubeListBuilder)rightPants.left(), (PartPose)rightPants.right());
        PartDefinition partDefinition22 = partDefinition.m_171599_("left_pants", (CubeListBuilder)leftPants.left(), (PartPose)leftPants.right());
        partDefinition11.m_171599_("right_lower_pants", (CubeListBuilder)rightLowerPants.left(), (PartPose)rightLowerPants.right());
        partDefinition22.m_171599_("left_lower_pants", (CubeListBuilder)leftLowerPants.left(), (PartPose)leftLowerPants.right());
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_, (Object)this.leftPants, (Object)this.rightPants, (Object)this.f_103374_, (Object)this.f_103375_, (Object)this.f_103378_);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        KneesModel.setupAnim(this, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightPants.m_104315_(this.f_102813_);
        this.leftPants.m_104315_(this.f_102814_);
        this.rightLowerPants.m_104315_(this.rightShin);
        this.leftLowerPants.m_104315_(this.leftShin);
    }

    public void m_102872_(HumanoidModel<T> model) {
        super.m_102872_(model);
        KneesModel.copyPropertiesTo(this, model);
    }

    @Override
    public ModelPart rightShin() {
        return this.rightShin;
    }

    @Override
    public ModelPart leftShin() {
        return this.leftShin;
    }
}

