/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.procedures;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ZTargetSystem {
    private static final Map<UUID, WeakReference<Entity>> targetingMap = new HashMap<UUID, WeakReference<Entity>>();

    public static Entity findTarget(Player player, double range) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 targetPos = eyePos.m_82549_(lookVec.m_82490_(range));
        AABB searchBox = new AABB(eyePos, targetPos).m_82400_(1.0);
        Entity nearestTarget = null;
        double nearestDistance = range;
        for (Entity entity : player.m_9236_().m_6249_((Entity)player, searchBox, e -> !(e instanceof Player) && e.m_6084_())) {
            double distance = entity.m_20270_((Entity)player);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = entity;
        }
        return nearestTarget;
    }

    public static void setTarget(Player player, Entity target) {
        if (target != null) {
            targetingMap.put(player.m_20148_(), new WeakReference<Entity>(target));
        } else {
            targetingMap.remove(player.m_20148_());
        }
    }

    public static Entity getTarget(Player player) {
        WeakReference<Entity> ref = targetingMap.get(player.m_20148_());
        return ref != null ? (Entity)ref.get() : null;
    }

    public static void updateCameraToTarget(Player player) {
        Entity target = ZTargetSystem.getTarget(player);
        if (target != null) {
            Vec3 playerPos = player.m_20182_();
            Vec3 targetPos = target.m_20182_();
            double dx = targetPos.f_82479_ - playerPos.f_82479_;
            double dy = targetPos.f_82480_ + (double)(target.m_20206_() / 2.0f) - (playerPos.f_82480_ + (double)player.m_20192_());
            double dz = targetPos.f_82481_ - playerPos.f_82481_;
            float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            player.m_146922_(yaw);
            player.m_146926_(pitch);
            player.f_20885_ = yaw;
            player.f_20883_ = yaw;
        }
    }
}

