/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.procedures;

import com.jujutsu.jujutsucraftaddon.network.JujutsucraftaddonModVariables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.loading.FMLPaths;

public class GrabPlayerTextureProcedure {
    public static void execute(Entity entity) {
        String texturePath;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID uuid = player.m_20148_();
        MinecraftSessionService sessionService = player.f_8924_.m_129925_();
        GameProfile profile = new GameProfile(uuid, null);
        Map textures = sessionService.getTextures(sessionService.fillProfileProperties(profile, false), false);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
            String skinUrl = profileTexture.getUrl();
            String skinHash = profileTexture.getHash();
            ResourceLocation resourceLocation = new ResourceLocation("skins/" + skinHash);
            File skinDir = new File(FMLPaths.GAMEDIR.get().toFile(), "cached_skins");
            File skinFile = new File(skinDir, skinHash + ".png");
            if (!skinDir.exists()) {
                skinDir.mkdirs();
            }
            if (!skinFile.exists()) {
                try {
                    GrabPlayerTextureProcedure.downloadSkin(skinUrl, skinFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = DefaultPlayerSkin.m_118627_((UUID)uuid).toString();
                }
            }
            texturePath = resourceLocation.toString();
        } else {
            texturePath = DefaultPlayerSkin.m_118627_((UUID)uuid).toString();
        }
        String finalTexturePath = texturePath;
        entity.getCapability(JujutsucraftaddonModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.PlayerTexture = finalTexturePath;
            capability.syncPlayerVariables(entity);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadSkin(String skinUrl, File skinFile) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(skinUrl).openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try (InputStream inputStream = connection.getInputStream();){
            Files.copy(inputStream, skinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            connection.disconnect();
        }
    }
}

