/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.network;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.procedures.BarrierlessKeyOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.ExtensionDomainKeyOnPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.RCTBurnoutKeyProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.RCTMasteryKeyOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.RCTOutputKeyOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.SimpleDomainKeyOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.world.inventory.WorldSkillMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldSkillButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public WorldSkillButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public WorldSkillButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(WorldSkillButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(WorldSkillButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            WorldSkillButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = WorldSkillMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RCTBurnoutKeyProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RCTMasteryKeyOnKeyPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            SimpleDomainKeyOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ExtensionDomainKeyOnPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            RCTOutputKeyOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            BarrierlessKeyOnKeyPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(WorldSkillButtonMessage.class, WorldSkillButtonMessage::buffer, WorldSkillButtonMessage::new, WorldSkillButtonMessage::handler);
    }
}

