/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.network;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.procedures.EffectsAction;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PacketEffects {
    int page;
    UUID playerUUID;
    private static final Map<Integer, Boolean> keyState = new HashMap<Integer, Boolean>();
    private static final Map<UUID, Integer> pressCounter = new HashMap<UUID, Integer>();

    public PacketEffects(int page, UUID playerUUID) {
        this.page = page;
        this.playerUUID = playerUUID;
    }

    public PacketEffects(FriendlyByteBuf buffer) {
        this.page = buffer.readInt();
        this.playerUUID = buffer.m_130259_();
    }

    public static void buffer(PacketEffects message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.page);
        buffer.m_130077_(message.playerUUID);
    }

    public static void handler(PacketEffects message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            ServerLevel serverLevel = serverPlayer.f_8924_.m_129880_(serverPlayer.m_9236_().m_46472_());
            if (serverLevel == null) {
                return;
            }
            Player targetPlayer = serverLevel.m_46003_(message.playerUUID);
            if (targetPlayer == null) {
                return;
            }
            int currentCount = pressCounter.getOrDefault(message.playerUUID, 0);
            if (++currentCount >= 2) {
                EffectsAction.execute(targetPlayer, message.page);
                pressCounter.put(message.playerUUID, 0);
            } else {
                pressCounter.put(message.playerUUID, currentCount);
            }
        });
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(PacketEffects.class, PacketEffects::buffer, PacketEffects::new, PacketEffects::handler);
    }
}

