/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.network;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.procedures.BarToggle;
import com.jujutsu.jujutsucraftaddon.procedures.CursedWeaponOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.DashTogglProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.DisableOrEnableAnimationsProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.FogToggle;
import com.jujutsu.jujutsucraftaddon.procedures.FramesProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.GojukunaProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.HistoryModeOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.OstProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.OverlayActiveOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.ProgressionMenuOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.UnlockExtensionProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.WaterWalkingOnKeyPressedProcedure;
import com.jujutsu.jujutsucraftaddon.world.inventory.NewTabMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NewTabButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public NewTabButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NewTabButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(NewTabButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(NewTabButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            NewTabButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = NewTabMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            UnlockExtensionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OverlayActiveOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            HistoryModeOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            CursedWeaponOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            WaterWalkingOnKeyPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            ProgressionMenuOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OstProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            FramesProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            DashTogglProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            DisableOrEnableAnimationsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            GojukunaProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            FogToggle.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 12) {
            BarToggle.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(NewTabButtonMessage.class, NewTabButtonMessage::buffer, NewTabButtonMessage::new, NewTabButtonMessage::handler);
    }
}

