/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.network;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.procedures.SelectFireProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.SelectLightningProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.SelectWaterProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.SelectWindProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.SetEarthProcedure;
import com.jujutsu.jujutsucraftaddon.world.inventory.ElementsMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ElementsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ElementsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ElementsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ElementsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ElementsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ElementsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ElementsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SelectLightningProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SelectFireProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SetEarthProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SelectWaterProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SelectWindProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(ElementsButtonMessage.class, ElementsButtonMessage::buffer, ElementsButtonMessage::new, ElementsButtonMessage::handler);
    }
}

