/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.network;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerEquip1Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerEquip2Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerEquip3Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerRoll2Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerRollProcedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerRollSlot1Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanChangerRollSlot3Procedure;
import com.jujutsu.jujutsucraftaddon.procedures.ClanInformationProcedure;
import com.jujutsu.jujutsucraftaddon.world.inventory.ClanChangeMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClanChangeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ClanChangeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ClanChangeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ClanChangeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ClanChangeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ClanChangeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ClanChangeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ClanChangerRollProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ClanInformationProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ClanChangerRollSlot1Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ClanChangerEquip1Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ClanChangerRoll2Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ClanChangerEquip2Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ClanChangerRollSlot3Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            ClanChangerEquip3Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(ClanChangeButtonMessage.class, ClanChangeButtonMessage::buffer, ClanChangeButtonMessage::new, ClanChangeButtonMessage::handler);
    }
}

