/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.misc;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class CombatDetection {
    private static final long COMBAT_DURATION = 5000L;
    private static final Timer timer = new Timer();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            final Player player = (Player)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_41782_() || !stack.m_41783_().m_128441_("WeaponSize")) continue;
                CombatDetection.setCombatState(stack, true);
            }
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        CombatDetection.setCombatState(stack, false);
                    }
                }
            }, 5000L);
        }
    }

    private static void setCombatState(ItemStack stack, boolean inCombat) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("InCombat", inCombat);
    }
}

