/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.client.screens;

import com.jujutsu.jujutsucraftaddon.client.screens.AbilityTab;
import com.jujutsu.jujutsucraftaddon.client.screens.JJKTab;
import com.jujutsu.jujutsucraftaddon.client.screens.JJKTabType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JujutsuMenuScreen
extends Screen {
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 140;
    public static final int WINDOW_INSIDE_WIDTH = 234;
    public static final int WINDOW_INSIDE_HEIGHT = 113;
    public static final int BACKGROUND_TILE_WIDTH = 16;
    public static final int BACKGROUND_TILE_HEIGHT = 16;
    private static final ResourceLocation WINDOW = new ResourceLocation("textures/gui/advancements/window.png");
    private static final int WINDOW_INSIDE_X = 9;
    private static final int WINDOW_INSIDE_Y = 18;
    private static int tabPage;
    private static int maxPages;
    private final List<JJKTab> tabs = new ArrayList<JJKTab>();
    @Nullable
    private JJKTab selectedTab;
    private boolean isScrolling;

    public JujutsuMenuScreen() {
        super((Component)Component.m_237119_());
    }

    public void m_280273_(@NotNull GuiGraphics pGuiGraphics) {
    }

    private void setSelectedTab(@NotNull JJKTab tab) {
        if (this.selectedTab != null) {
            for (GuiEventListener widget : this.selectedTab.getRenderables()) {
                this.m_169411_(widget);
            }
            this.selectedTab.removeWidgets();
        }
        this.selectedTab = tab;
        this.selectedTab.addWidgets();
    }

    public void removeWidgets() {
        if (this.selectedTab != null) {
            for (GuiEventListener widget : this.selectedTab.getRenderables()) {
                this.m_169411_(widget);
            }
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.selectedTab != null) {
            this.selectedTab.tick();
        }
    }

    @NotNull
    public <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T pWidget) {
        return (T)super.m_142416_(pWidget);
    }

    protected void m_7856_() {
        this.tabs.clear();
        this.selectedTab = null;
        this.tabs.add(new AbilityTab(this.f_96541_, this, JJKTabType.ABOVE, 0, 0));
        this.setSelectedTab(this.tabs.get(0));
        if (this.tabs.size() > JJKTabType.MAX_TABS) {
            int guiLeft = (this.f_96543_ - 252) / 2;
            int guiTop = (this.f_96544_ - 140) / 2;
            this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252794_(guiLeft, guiTop - 50).m_253046_(20, 20).m_253136_());
            this.m_142416_(Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252794_(guiLeft + 252 - 20, guiTop - 50).m_253046_(20, 20).m_253136_());
            maxPages = this.tabs.size() / JJKTabType.MAX_TABS;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int j;
        int i;
        if (this.selectedTab != null) {
            i = (this.f_96543_ - 252) / 2;
            j = (this.f_96544_ - 140) / 2;
            this.selectedTab.mouseClicked(pMouseX - (double)i - 9.0, pMouseY - (double)j - 18.0, pButton);
        }
        if (pButton == 0) {
            i = (this.f_96543_ - 252) / 2;
            j = (this.f_96544_ - 140) / 2;
            for (JJKTab tab : this.tabs) {
                if (tab.getPage() != tabPage || !tab.isMouseOver(i, j, pMouseX, pMouseY)) continue;
                this.setSelectedTab(tab);
                break;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.selectedTab != null) {
            int i = (this.f_96543_ - 252) / 2;
            int j = (this.f_96544_ - 140) / 2;
            this.selectedTab.mouseReleased(pMouseX - (double)i - 9.0, pMouseY - (double)j - 18.0, pButton);
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selectedTab != null) {
            this.selectedTab.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i = (this.f_96543_ - 252) / 2;
        int j = (this.f_96544_ - 140) / 2;
        if (maxPages != 0) {
            MutableComponent page = Component.m_237113_((String)String.format("%d / %d", tabPage + 1, maxPages + 1));
            int width = this.f_96547_.m_92852_((FormattedText)page);
            pGuiGraphics.m_280648_(this.f_96547_, page.m_7532_(), i + 126 - width / 2, j - 44, -1);
        }
        this.renderInside(pGuiGraphics, i, j);
        this.renderWindow(pGuiGraphics, i, j);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, i, j);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private void renderInside(GuiGraphics graphics, int offsetX, int offsetY) {
        if (this.selectedTab != null) {
            this.selectedTab.drawContents(graphics, offsetX + 9, offsetY + 18);
        }
    }

    public void renderWindow(GuiGraphics graphics, int offsetX, int offsetY) {
        RenderSystem.enableBlend();
        graphics.m_280218_(WINDOW, offsetX, offsetY, 0, 0, 252, 140);
        for (JJKTab tab : this.tabs) {
            if (tab.getPage() != tabPage) continue;
            tab.drawTab(graphics, offsetX, offsetY, tab == this.selectedTab);
        }
        for (JJKTab tab : this.tabs) {
            if (tab.getPage() != tabPage) continue;
            tab.drawIcon(graphics, offsetX, offsetY);
        }
    }

    private void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, int offsetX, int offsetY) {
        if (this.selectedTab != null) {
            this.selectedTab.drawTooltips(graphics, mouseX, mouseY, offsetX, offsetY);
        }
        for (JJKTab JJKTab2 : this.tabs) {
            if (JJKTab2.getPage() != tabPage || !JJKTab2.isMouseOver(offsetX, offsetY, mouseX, mouseY)) continue;
            graphics.m_280557_(this.f_96547_, JJKTab2.getTitle(), mouseX, mouseY);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(pDragX, pDragY);
        }
        return true;
    }
}

