/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.client.screens;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public enum JJKTabType {
    ABOVE(28, 32, 8),
    BELOW(28, 32, 8),
    LEFT(32, 28, 5),
    RIGHT(32, 28, 5);

    public static final int MAX_TABS;
    private static final ResourceLocation[] SELECTED;
    private static final ResourceLocation[] UNSELECTED;
    private final int width;
    private final int height;
    private final int max;

    private JJKTabType(int pWidth, int pHeight, int pMax) {
        this.width = pWidth;
        this.height = pHeight;
        this.max = pMax;
    }

    public int getMax() {
        return this.max;
    }

    public void draw(GuiGraphics pGuiGraphics, int pOffsetX, int pOffsetY, boolean pIsSelected, int pIndex) {
        ResourceLocation[] sprites;
        ResourceLocation[] resourceLocationArray = sprites = pIsSelected ? SELECTED : UNSELECTED;
        ResourceLocation sprite = pIndex == 0 ? sprites[0] : (pIndex == this.max - 1 ? sprites[2] : sprites[1]);
        pGuiGraphics.m_280218_(sprite, pOffsetX + this.getX(pIndex), pOffsetY + this.getY(pIndex), this.width, this.height, 0, 0);
    }

    public void drawIcon(GuiGraphics pGuiGraphics, int pOffsetX, int pOffsetY, int pIndex, ItemStack pStack) {
        int i = pOffsetX + this.getX(pIndex);
        int j = pOffsetY + this.getY(pIndex);
        switch (this) {
            case ABOVE: {
                i += 6;
                j += 9;
                break;
            }
            case BELOW: {
                i += 6;
                j += 6;
                break;
            }
            case LEFT: {
                i += 10;
                j += 5;
                break;
            }
            case RIGHT: {
                i += 6;
                j += 5;
            }
        }
        pGuiGraphics.m_280203_(pStack, i, j);
    }

    public int getX(int pIndex) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABOVE, BELOW -> (this.width + 4) * pIndex;
            case LEFT -> -this.width + 4;
            case RIGHT -> 248;
        };
    }

    public int getY(int pIndex) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABOVE -> -this.height + 4;
            case BELOW -> 136;
            case LEFT, RIGHT -> this.height * pIndex;
        };
    }

    public boolean isMouseOver(int pOffsetX, int pOffsetY, int pIndex, double pMouseX, double pMouseY) {
        int i = pOffsetX + this.getX(pIndex);
        int j = pOffsetY + this.getY(pIndex);
        return pMouseX > (double)i && pMouseX < (double)(i + this.width) && pMouseY > (double)j && pMouseY < (double)(j + this.height);
    }

    static {
        MAX_TABS = Arrays.stream(JJKTabType.values()).mapToInt(e -> e.max).sum();
        SELECTED = new ResourceLocation[]{new ResourceLocation("advancements/tab_above_left_selected"), new ResourceLocation("advancements/tab_above_middle_selected"), new ResourceLocation("advancements/tab_above_right_selected")};
        UNSELECTED = new ResourceLocation[]{new ResourceLocation("advancements/tab_above_left"), new ResourceLocation("advancements/tab_above_middle"), new ResourceLocation("advancements/tab_above_right")};
    }
}

