/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.client.screens;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.network.AltarMessageShortcut;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class AltarShortcut
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jujutsucraftaddon", "textures/gui/background.png");
    private static final int RADIUS_IN = 50;
    private static final int RADIUS_OUT = 100;
    private static final int MAX_ITEMS = 24;
    private int hover;
    private static int page;
    private final List<List<AltarOption>> pages = new ArrayList<List<AltarOption>>();
    private int hovered = -1;

    public AltarShortcut() {
        super((Component)Component.m_237113_((String)"Skill List"));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.pages.clear();
        List<AltarOption> options = this.getOptions();
        int count = options.size() / 24;
        for (int i = 0; i < count; ++i) {
            this.pages.add(options.subList(i * 24, (i + 1) * 24));
        }
        int remainder = options.size() % 24;
        if (remainder > 0) {
            this.pages.add(options.subList(count * 24, count * 24 + remainder));
        }
        if (page >= this.pages.size()) {
            page = 0;
        }
        if (this.pages.isEmpty()) {
            this.m_7379_();
        }
    }

    private List<AltarOption> getOptions() {
        ArrayList<AltarOption> options = new ArrayList<AltarOption>();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return options;
        }
        UUID playerUUID = player.m_20148_();
        options.add(new AltarOption("Passive(CT)", 0, (Player)player));
        options.add(new AltarOption("Cursed Fists", 1, (Player)player));
        options.add(new AltarOption("Cursed Mastery", 2, (Player)player));
        options.add(new AltarOption("Domain Expansion", 3, (Player)player));
        options.add(new AltarOption("Domain Type", 4, (Player)player));
        return options;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        KeyMapping input = mc.f_91066_.f_92085_;
        if (keyCode == mc.f_91066_.f_92092_.getKey().m_84873_()) {
            input.m_7249_(true);
            this.m_7379_();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.getCurrent().size(); ++i) {
            float startAngle = this.getAngleFor((float)i - 0.5f);
            float endAngle = this.getAngleFor((float)i + 0.5f);
            AltarOption item = this.getCurrent().get(i);
            int black = AltarShortcut.toRGB24(0, 0, 0, 150);
            int white = AltarShortcut.toRGB24(255, 50, 50, 150);
            int color = this.hovered > 0 ? (this.hovered == i ? black : white) : (this.hovered == 0 ? (this.hovered == i ? white : black) : black);
            this.drawTexturedCircle(guiGraphics.m_280168_(), buffer, centerX, centerY, startAngle, endAngle, color);
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        guiGraphics.m_280168_().m_85849_();
        this.renderText(guiGraphics, centerX, centerY);
    }

    private void drawTexturedCircle(PoseStack poseStack, BufferBuilder buffer, float centerX, float centerY, float startAngle, float endAngle, int color) {
        float angle = endAngle - startAngle;
        float precision = 0.0069444445f;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / precision)));
        angle = endAngle - startAngle;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        float slice = angle / (float)sections;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i * slice;
            float angle2 = startAngle + (float)(i + 1) * slice;
            float x1 = centerX + 50.0f * (float)Math.cos(angle1);
            float y1 = centerY + 50.0f * (float)Math.sin(angle1);
            float x2 = centerX + 100.0f * (float)Math.cos(angle1);
            float y2 = centerY + 100.0f * (float)Math.sin(angle1);
            float x3 = centerX + 100.0f * (float)Math.cos(angle2);
            float y3 = centerY + 100.0f * (float)Math.sin(angle2);
            float x4 = centerX + 50.0f * (float)Math.cos(angle2);
            float y4 = centerY + 50.0f * (float)Math.sin(angle2);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(matrix4f, x2, y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix4f, x1, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix4f, x4, y4, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix4f, x3, y3, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
    }

    private static int toRGB24(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void renderText(@NotNull GuiGraphics guiGraphics, int centerX, int centerY) {
        float radius = 75.0f;
        for (int i = 0; i < this.getCurrent().size(); ++i) {
            float angle = this.getAngleFor(i);
            int x = (int)((double)centerX + (double)radius * Math.cos(angle));
            int y = (int)((double)centerY + (double)radius * Math.sin(angle));
            int color = this.hovered == i ? 0xFFFFFF : 0x888888;
            guiGraphics.m_280137_(this.f_96547_, this.getCurrent().get((int)i).name, x, y, color);
        }
    }

    private List<? extends AltarOption> getCurrent() {
        return this.pages.get(page);
    }

    private float getAngleFor(float index) {
        return index / (float)this.getCurrent().size() * ((float)Math.PI * 2) - 1.5707964f;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hovered >= 0) {
            this.getCurrent().get(this.hovered).onSelect();
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.hovered == -1) {
            return;
        }
        List<AltarOption> items = this.pages.get(page);
        if (this.hovered >= items.size()) {
            return;
        }
        AltarOption item = items.get(this.hovered);
        item.onSelect();
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        super.m_94757_(pMouseX, pMouseY);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        double mousePos = Math.sqrt(Math.pow(pMouseX - (double)centerX, 2.0) + Math.pow(pMouseY - (double)centerY, 2.0));
        if (!this.getCurrent().isEmpty()) {
            double mouseAngle;
            float startAngle = this.getAngleFor(-0.5f);
            float endAngle = this.getAngleFor((float)this.getCurrent().size() - 0.5f);
            for (mouseAngle = Math.atan2(pMouseY - (double)centerY, pMouseX - (double)centerX); mouseAngle < (double)startAngle; mouseAngle += 6.2831854820251465) {
            }
            while (mouseAngle >= (double)endAngle) {
                mouseAngle -= 6.2831854820251465;
            }
            this.hovered = -1;
            for (int i = 0; i < this.getCurrent().size(); ++i) {
                float currentStart = this.getAngleFor((float)i - 0.5f);
                float currentEnd = this.getAngleFor((float)i + 0.5f);
                if (!(mouseAngle >= (double)currentStart) || !(mouseAngle < (double)currentEnd) || !(mousePos >= 50.0) || !(mousePos < 100.0)) continue;
                this.hovered = i;
                break;
            }
            if (mousePos < 100.0) {
                return;
            }
            if (this.pages.size() > 1) {
                if (this.pages.size() - 1 > page && pMouseX > (double)this.f_96543_ / 2.0 && pMouseX < (double)this.f_96543_ && pMouseY > 0.0 && pMouseY < (double)this.f_96544_) {
                    if (++this.hover == 20) {
                        ++page;
                    }
                    if (this.hover == 60) {
                        this.hover = 0;
                    }
                    return;
                }
                if (page > 0 && pMouseX > 0.0 && pMouseX < (double)this.f_96543_ / 2.0 && pMouseY > 0.0 && pMouseY < (double)this.f_96544_) {
                    if (++this.hover == 20) {
                        --page;
                    }
                    if (this.hover == 60) {
                        this.hover = 0;
                    }
                    return;
                }
                if (this.hover > 0) {
                    this.hover = 0;
                }
            }
        }
    }

    private static class AltarOption {
        final String name;
        private int index;
        final UUID playerUUID;

        AltarOption(String name, int index, Player player) {
            this.name = name;
            this.index = index;
            this.playerUUID = player.m_20148_();
        }

        void onSelect() {
            JujutsucraftaddonMod.PACKET_HANDLER.sendToServer((Object)new AltarMessageShortcut(this.index, this.playerUUID));
        }
    }
}

