/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class WaterSurgeAbility {
    private static final int WAVE_LENGTH = 10;
    private static final int WAVE_HEIGHT = 3;
    private static final int WAVE_LIFETIME = 60;
    private static final double PUSH_FORCE = 1.2;
    private static final List<ScheduledWaveRemoval> scheduledRemovals = new ArrayList<ScheduledWaveRemoval>();

    public static void createWaterSurge(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        float yaw = player.m_146908_();
        int dirX = (int)Math.round(-Math.sin(Math.toRadians(yaw)));
        int dirZ = (int)Math.round(Math.cos(Math.toRadians(yaw)));
        BlockPos startPos = player.m_20183_().m_7918_(dirX * 2, 0, dirZ * 2);
        ArrayList<BlockPos> placedBlocks = new ArrayList<BlockPos>();
        for (int z = 0; z < 10; ++z) {
            for (int y = 0; y < 3; ++y) {
                BlockPos pos = startPos.m_7918_(dirX * z, y, dirZ * z);
                if (!serverLevel.m_8055_(pos).m_60795_()) continue;
                serverLevel.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                placedBlocks.add(pos);
            }
        }
        WaterSurgeAbility.pushEntities(serverLevel, startPos, dirX, dirZ);
        scheduledRemovals.add(new ScheduledWaveRemoval(serverLevel, placedBlocks, 60));
    }

    private static void pushEntities(ServerLevel level, BlockPos startPos, int dirX, int dirZ) {
        List nearbyEntities = level.m_45933_(null, new AABB((double)(startPos.m_123341_() - 5), (double)startPos.m_123342_(), (double)(startPos.m_123343_() - 5), (double)(startPos.m_123341_() + 5), (double)(startPos.m_123342_() + 3), (double)(startPos.m_123343_() + 10)));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20334_((double)dirX * 1.2, 0.3, (double)dirZ * 1.2);
            entity.f_19864_ = true;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<ScheduledWaveRemoval> iterator = scheduledRemovals.iterator();
            while (iterator.hasNext()) {
                ScheduledWaveRemoval removal = iterator.next();
                --removal.ticksLeft;
                if (removal.ticksLeft > 0) continue;
                for (BlockPos blockPos : removal.blockPositions) {
                    if (!removal.level.m_8055_(blockPos).m_60713_(Blocks.f_49990_)) continue;
                    removal.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                }
                iterator.remove();
            }
        }
    }

    private static class ScheduledWaveRemoval {
        private final ServerLevel level;
        private final List<BlockPos> blockPositions;
        private int ticksLeft;

        public ScheduledWaveRemoval(ServerLevel level, List<BlockPos> blockPositions, int ticksLeft) {
            this.level = level;
            this.blockPositions = blockPositions;
            this.ticksLeft = ticksLeft;
        }
    }
}

